using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class GroupsService : BaseWebServiceClient
    {
        public GroupsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<GroupNotification> Create(CreateGroupRequest request) {
			return Post<GroupNotification>("groups", request);
		}

		public ServiceResponse Settings(Guid groupID, ModifyGroupSettingsRequest request) {
			return Post(string.Format("groups/{0}/settings", groupID), request);
		}

		public ServiceResponse<GroupMemberContract[]> GetMembers(Guid groupID, bool actives, int page, int pageSize) {
			return Get<GroupMemberContract[]>(string.Format("groups/{0}/members", groupID) + string.Format("?actives={0}&page={1}&pageSize={2}",actives,page,pageSize));
		}

		public ServiceResponse AddMembers(Guid groupID, int[] userIDs) {
			return Post(string.Format("groups/{0}/members", groupID), userIDs);
		}

		public ServiceResponse<GroupMemberContract[]> QuickSearchMembers(Guid groupID, string query) {
			return Get<GroupMemberContract[]>(string.Format("groups/{0}/members/simple-search", groupID) + string.Format("?query={0}",query));
		}

		public ServiceResponse<GroupMemberContract[]> SearchMembers(Guid groupID, GroupMemberSearchRequest request) {
			return Post<GroupMemberContract[]>(string.Format("groups/{0}/members/search", groupID), request);
		}

		public ServiceResponse RemoveMember(Guid groupID, int userID) {
			return Delete(string.Format("groups/{0}/members/{1}", groupID, userID));
		}

		public ServiceResponse TransferOwnership(Guid groupID, int userID) {
			return Post(string.Format("groups/{0}/members/transfer-ownership", groupID), userID);
		}

		public ServiceResponse<GroupNotification> Details(Guid groupID, bool showDeletedChannels) {
			return Get<GroupNotification>(string.Format("groups/{0}", groupID) + string.Format("?showDeletedChannels={0}",showDeletedChannels));
		}

		public ServiceResponse Favorite(Guid groupID) {
			return Post(string.Format("groups/{0}/favorite", groupID));
		}

		public ServiceResponse Unfavorite(Guid groupID) {
			return Post(string.Format("groups/{0}/unfavorite", groupID));
		}

		public ServiceResponse Leave(Guid groupID) {
			return Post(string.Format("groups/{0}/leave", groupID));
		}

		public ServiceResponse ChangeNotificationPreferences(Guid groupID, GroupNotificationPreferences preferences) {
			return Post(string.Format("groups/{0}/notification-preferences", groupID), preferences);
		}

		public ServiceResponse<GroupEventContract[]> GetGroupEvents(Guid groupID, int? pageSize, int? pageNumber) {
			return Get<GroupEventContract[]>(string.Format("groups/{0}/events", groupID) + string.Format("?pageSize={0}&pageNumber={1}",pageSize,pageNumber));
		}


    }
}
