using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class LoginService : BaseWebServiceClient
    {
        public LoginService(string url) : base(url)
        {
            
        }

		public ServiceResponse<LoginResponse> Login(LoginRequest loginRequest) {
			return Post<LoginResponse>("login", loginRequest);
		}

		public ServiceResponse<RenewTokenResponseContract> RenewToken() {
			return Post<RenewTokenResponseContract>("login/renew");
		}

		public ServiceResponse<LoginResponse> LoginWithNetworkSession(LoginWithNetworkSessionRequest request) {
			return Post<LoginResponse>("login/network-session", request);
		}


    }
}
