using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class PollService : BaseWebServiceClient
    {
        public PollService(string url) : base(url)
        {
            
        }

		public ServiceResponse<ActivePollContract[]> GetActive(Guid groupID) {
			return Get<ActivePollContract[]>(string.Format("polls/{0}", groupID));
		}

		public ServiceResponse<GroupPollNotification> Create(Guid groupID, CreatePollRequest request) {
			return Post<GroupPollNotification>(string.Format("polls/{0}", groupID), request);
		}

		public ServiceResponse<GroupPollNotification> Get(Guid groupID, int pollID) {
			return Get<GroupPollNotification>(string.Format("polls/{0}/{1}", groupID, pollID));
		}

		public ServiceResponse<GroupPollSettingsNotification> GetLatestSettings(Guid groupID) {
			return Get<GroupPollSettingsNotification>(string.Format("polls/{0}/settings", groupID));
		}

		public ServiceResponse<GroupPollResult[]> GetPollHistory(Guid groupID, int pageSize, int pageNumber) {
			return Get<GroupPollResult[]>(string.Format("polls/{0}/history", groupID) + string.Format("?pageSize={0}&pageNumber={1}",pageSize,pageNumber));
		}

		public ServiceResponse<GroupPollResult[]> SearchPollHistory(Guid groupID, SearchPollHistoryRequest request) {
			return Post<GroupPollResult[]>(string.Format("polls/{0}/history/search", groupID), request);
		}

		public ServiceResponse End(Guid groupID, int pollID) {
			return Delete(string.Format("polls/{0}/{1}", groupID, pollID));
		}

		public ServiceResponse Deactivate(Guid groupID, int pollID) {
			return Delete(string.Format("polls/{0}/{1}/deactivate", groupID, pollID));
		}

		public ServiceResponse<int[]> GetMyVote(Guid groupID, int pollID) {
			return Get<int[]>(string.Format("polls/{0}/{1}/votes", groupID, pollID));
		}

		public ServiceResponse<ActivePollContract> Vote(Guid groupID, int pollID, int[] vote) {
			return Post<ActivePollContract>(string.Format("polls/{0}/{1}/votes", groupID, pollID), vote);
		}

		public ServiceResponse<PublicActivePollContract> GetPublicPoll(string pollCode) {
			return Get<PublicActivePollContract>(string.Format("polls/public/{0}", pollCode));
		}

		public ServiceResponse<PublicActivePollContract> VotePublicPoll(string pollCode, int[] votes) {
			return Post<PublicActivePollContract>(string.Format("polls/public/{0}/votes", pollCode), votes);
		}


    }
}
