using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class PrivateMessagesService : BaseWebServiceClient
    {
        public PrivateMessagesService(string url) : base(url)
        {
            
        }

		public ServiceResponse<GroupPrivateConversationContract[]> GetAll(Guid groupID) {
			return Get<GroupPrivateConversationContract[]>(string.Format("groups/{0}/private-messages", groupID));
		}

		public ServiceResponse Block(Guid groupID, int userID) {
			return Post(string.Format("groups/{0}/private-messages/{1}/block", groupID, userID));
		}

		public ServiceResponse Unblock(Guid groupID, int userID) {
			return Post(string.Format("groups/{0}/private-messages/{1}/unblock", groupID, userID));
		}


    }
}
