using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class ServersService : BaseWebServiceClient
    {
        public ServersService(string url) : base(url)
        {
            
        }

		public ServiceResponse<GroupSearchModelContract[]> SimpleSearch(string query, int? pageSize, int? pageNumber) {
			return Get<GroupSearchModelContract[]>("servers" + string.Format("?query={0}&pageSize={1}&pageNumber={2}",query,pageSize,pageNumber));
		}

		public ServiceResponse<GroupSearchModelContract[]> Search(SearchServersRequest request) {
			return Post<GroupSearchModelContract[]>("servers/search", request);
		}

		public ServiceResponse<GroupNotification> Create(CreateServerRequest request) {
			return Post<GroupNotification>("servers", request);
		}

		public ServiceResponse<CreateStreamerCommunityGroupResponse> CreateStreamCommunity(CreateStreamerCommunityGroupRequest request) {
			return Post<CreateStreamerCommunityGroupResponse>("servers/stream-community", request);
		}

		public ServiceResponse<GroupNotification> CreateGuildCommunity(CreateGuildCommunityRequest request) {
			return Post<GroupNotification>("servers/guild-community", request);
		}

		public ServiceResponse<string> GetFromUrl(string url) {
			return Get<string>(string.Format("servers/url/{0}", url));
		}

		public ServiceResponse<ValidateUrlStatus> ValidateUrl(string url) {
			return Get<ValidateUrlStatus>(string.Format("servers/url/{0}/validate", url));
		}

		public ServiceResponse<ServerGeneralSettingsContract> GetGeneralSettings(Guid groupID) {
			return Get<ServerGeneralSettingsContract>(string.Format("servers/{0}/settings/general", groupID));
		}

		public ServiceResponse SetGeneralSettings(Guid groupID, ServerGeneralSettingsContract request) {
			return Post(string.Format("servers/{0}/settings/general", groupID), request);
		}

		public ServiceResponse<ServerSearchSettingsContract> GetSearchSettings(Guid groupID) {
			return Get<ServerSearchSettingsContract>(string.Format("servers/{0}/settings/search", groupID));
		}

		public ServiceResponse SetSearchSettings(Guid groupID, ServerSearchSettingsContract request) {
			return Post(string.Format("servers/{0}/settings/search", groupID), request);
		}

		public ServiceResponse<ChannelContract> CreateChannel(Guid groupID, CreateChannelRequest request) {
			return Post<ChannelContract>(string.Format("servers/{0}/channels", groupID), request);
		}

		public ServiceResponse DeleteChannel(Guid groupID, Guid channelID) {
			return Delete(string.Format("servers/{0}/channels/{1}", groupID, channelID));
		}

		public ServiceResponse ChannelSettings(Guid groupID, Guid channelID, ModifyChannelSettingsRequest request) {
			return Post(string.Format("servers/{0}/channels/{1}/settings", groupID, channelID), request);
		}

		public ServiceResponse Delete(Guid groupID) {
			return Delete(string.Format("servers/{0}", groupID));
		}

		public ServiceResponse Restore(Guid groupID) {
			return Post(string.Format("servers/{0}/restore", groupID));
		}

		public ServiceResponse Reorder(Guid groupID, ReorganizeGroupRequest request) {
			return Post(string.Format("servers/{0}/reorder", groupID), request);
		}

		public ServiceResponse<GroupNotification> JoinServer(Guid groupID) {
			return Post<GroupNotification>(string.Format("servers/{0}/join", groupID));
		}

		public ServiceResponse AddEmoticon(Guid groupID, AddEmoticonRequest request) {
			return Post(string.Format("servers/{0}/emoticons", groupID), request);
		}

		public ServiceResponse RemoveEmoticon(Guid groupID, string id) {
			return Delete(string.Format("servers/{0}/emoticons/{1}", groupID, id));
		}

		public ServiceResponse<GroupRoleDetails[]> GetRoles(Guid groupID) {
			return Get<GroupRoleDetails[]>(string.Format("servers/{0}/roles", groupID));
		}

		public ServiceResponse<GroupRoleDetails> GetRole(Guid groupID, int roleID) {
			return Get<GroupRoleDetails>(string.Format("servers/{0}/roles/{1}", groupID, roleID));
		}

		public ServiceResponse<GroupRoleDetails> CreateRole(Guid groupID, CreateGroupRoleRequest request) {
			return Post<GroupRoleDetails>(string.Format("servers/{0}/roles", groupID), request);
		}

		public ServiceResponse<GroupRoleDetails> ModifyRole(Guid groupID, int roleID, ModifyGroupRoleRequest request) {
			return Post<GroupRoleDetails>(string.Format("servers/{0}/roles/{1}", groupID, roleID), request);
		}

		public ServiceResponse<GroupRoleDetails[]> ModifyRoleRanks(Guid groupID, Dictionary<int, int>  roleRanks) {
			return Post<GroupRoleDetails[]>(string.Format("servers/{0}/roles/ranks", groupID), roleRanks);
		}

		public ServiceResponse DeleteRole(Guid groupID, int roleID) {
			return Delete(string.Format("servers/{0}/roles/{1}", groupID, roleID));
		}

		public ServiceResponse<GroupRoleDetails> ModifyRolePermissions(Guid groupID, Guid channelID, int roleID, ModifyGroupRolePermissionsRequest request) {
			return Post<GroupRoleDetails>(string.Format("servers/{0}/roles/{2}/permissions/{1}", groupID, channelID, roleID), request);
		}

		public ServiceResponse<GroupMemberContract> AddMemberRole(Guid groupID, int userID, int roleID) {
			return Post<GroupMemberContract>(string.Format("servers/{0}/members/{1}/roles", groupID, userID), roleID);
		}

		public ServiceResponse<GroupMemberContract> RemoveMemberRole(Guid groupID, int userID, int roleID) {
			return Delete<GroupMemberContract>(string.Format("servers/{0}/members/{1}/roles/{2}", groupID, userID, roleID));
		}

		public ServiceResponse<GroupInvitationNotification> CreateInvite(Guid groupID, CreateGroupInviteRequest request) {
			return Post<GroupInvitationNotification>(string.Format("servers/{0}/invites", groupID), request);
		}

		public ServiceResponse<GroupInvitationNotification[]> GetInvites(Guid groupID) {
			return Get<GroupInvitationNotification[]>(string.Format("servers/{0}/invites", groupID));
		}

		public ServiceResponse DeleteInvite(Guid groupID, string inviteCode, bool removeGuests) {
			return Delete(string.Format("servers/{0}/invites/{1}?removeGuests={removeGuests}", groupID, inviteCode));
		}

		public ServiceResponse<GroupBannedUserContract[]> GetBanList(Guid serverID, string query, int? pageSize, int? pageNumber) {
			return Get<GroupBannedUserContract[]>(string.Format("servers/{0}/bans", serverID) + string.Format("?query={0}&pageSize={1}&pageNumber={2}",query,pageSize,pageNumber));
		}

		public ServiceResponse<GroupBannedUserContract[]> SearchBannedUsers(Guid serverID, SearchBannedUsersRequest request) {
			return Post<GroupBannedUserContract[]>(string.Format("servers/{0}/bans/search", serverID), request);
		}

		public ServiceResponse<GroupBannedUserContract> BanUser(Guid serverID, int userID, string reason) {
			return Post<GroupBannedUserContract>(string.Format("servers/{0}/bans/{1}", serverID, userID), reason);
		}

		public ServiceResponse UnbanUser(Guid serverID, int userID) {
			return Delete(string.Format("servers/{0}/bans/{1}", serverID, userID));
		}

		public ServiceResponse<ExternalCommunityPublicContract[]> GetLiveStreamDetails(Guid serverID) {
			return Get<ExternalCommunityPublicContract[]>(string.Format("servers/{0}/live-streams", serverID));
		}


    }
}
