﻿using System.Net;

namespace Curse.ServiceClients
{
    public class ServiceResponse<T>
    {
        public HttpStatusCode StatusCode { get; set; }
        public T Response { get; set; }

        public ServiceResponse(HttpStatusCode statusCode)
        {
            StatusCode = statusCode;
        }

        public ServiceResponse(HttpStatusCode statusCode, T response)
        {
            StatusCode = statusCode;
            Response = response;
        }

        public bool Success
        {
            get { return (int)StatusCode >= 200 && (int)StatusCode < 300; }
        }
    }

    public class ServiceResponse
    {
        public HttpStatusCode StatusCode { get; set; }

        public ServiceResponse(HttpStatusCode statusCode)
        {
            StatusCode = statusCode;
        }

        public bool Success
        {
            get { return (int)StatusCode >= 200 && (int)StatusCode < 300; }
        }
    }
}
