﻿using System;
using System.Net;

namespace Curse.ServiceClients
{
    public class ServicesConfiguration
    {
        public bool DisableProxyDetection = true;
        public string UserAgent = null;
        public string ContentType = "application/json";
        public int TimeoutSeconds = 30;
        public Type CustomHttpHandler = null;
        
        public static IServicesLogProvider LogProvider = null;
        public static IServicesTokenProvider TokenProvider = null;

        public static void DisableCertificateValidation()
        {
            ServicePointManager.ServerCertificateValidationCallback = (sender, certificate, chain, sslPolicyErrors) => true;
        }

        public static void RefreshToken()
        {
            if (TokenProvider == null)
            {
                return;
            }

            ServiceAuthentication.Token = TokenProvider.GetToken();            
        }

        public static void LogInfo(string message)
        {
            if (LogProvider != null)
            {
                LogProvider.Info(message);
            }
        }

        public static void LogError(Exception ex, string message = null)
        {
            if (LogProvider != null)
            {
                LogProvider.Error(ex, message);
            }
        }


        public static void LogWarning(Exception ex, string message = null)
        {
            if (LogProvider != null)
            {
                LogProvider.Warn(ex, message);
            }
        }

        public static void LogWarning(string message)
        {
            if (LogProvider != null)
            {
                LogProvider.Warn(message);
            }
        }

        public static void SetLogProvider(IServicesLogProvider provider)
        {
            if (LogProvider != null)
            {
                return;
            }

            LogProvider = provider;
        }

        private class DebugUrls : ServiceUrls
        {           

            public override string Account
            {
                get { return "https://accounts.curseapp.dev"; }
            }

            public override string Bugs
            {
                get { return "https://bugs.curseapp.dev"; }
            }

            public override string Feedback
            {
                get { return "https://bugs.curseapp.dev"; }
            }

            public override string CallsAdmin
            {
                 get { return "https://calls.curseapp.dev"; }
            }

            public override string Calls
            {
                get { return "https://calls.curseapp.dev"; }
            }

            public override string FriendSuggestions
            {
                get { return "https://contacts.curseapp.dev"; }
            }

            public override string FriendSync
            {
                get { return "https://contacts.curseapp.dev"; }
            }

            public override string Friendships
            {
                get { return "https://contacts.curseapp.dev"; }
            }

            public override string Contacts
            {
               get { return "https://contacts.curseapp.dev"; }
            }

            public override string Users
            {
                get { return "https://contacts.curseapp.dev"; }
            }

            public override string Conversations
            {
                get { return "https://conversations.curseapp.dev"; }
            }

            public override string Giveaways
            {
                get { return "https://giveaways.curseapp.dev"; }
            }

            public override string GroupsApi
            {
                get { return "https://groups.curseapp.dev"; }
            }

            public override string Groups
            {
                get { return "https://groups.curseapp.dev"; }
            }

            public override string Invitations
            {
               get { return "https://groups.curseapp.dev"; }
            }

            public override string PrivateMessages
            {
                get { return "https://groups.curseapp.dev"; }
            }

            public override string Servers
            {
               get { return "https://groups.curseapp.dev"; }
            }

            public override string Poll
            {
                get { return "https://polls.curseapp.dev"; }
            }

            public override string Session
            {
                get { return "https://sessions.curseapp.dev"; }
            }

            public override string LinkedCommunities
            {
                get { return "https://sync.curseapp.dev"; }
            }

            public override string LinkedAccounts
            {
                get { return "https://sync.curseapp.dev"; }
            }

            public override string Login
            {
               get { return "https://logins.curseapp.dev"; }
            }

            public override string Register
            {
                get { return "https://logins.curseapp.dev"; }
            }

            public override string Stats
            {
                get { return "https://stats.curseapp.dev"; }
            }
        }

        private class StagingUrls : ServiceUrls
        {

            public override string Account
            {
                get { return "https://accounts.curseapp.tech"; }
            }

            public override string Bugs
            {
                get { return "https://bugs.curseapp.tech"; }
            }

            public override string Feedback
            {
                get { return "https://bugs.curseapp.tech"; }
            }

            public override string CallsAdmin
            {
                get { return "https://calls.curseapp.tech"; }
            }

            public override string Calls
            {
                get { return "https://calls.curseapp.tech"; }
            }

            public override string FriendSuggestions
            {
                get { return "https://contacts.curseapp.tech"; }
            }

            public override string FriendSync
            {
                get { return "https://contacts.curseapp.tech"; }
            }

            public override string Friendships
            {
                get { return "https://contacts.curseapp.tech"; }
            }

            public override string Contacts
            {
                get { return "https://contacts.curseapp.tech"; }
            }

            public override string Users
            {
                get { return "https://contacts.curseapp.tech"; }
            }

            public override string Conversations
            {
                get { return "https://conversations.curseapp.tech"; }
            }

            public override string Giveaways
            {
                get { return "https://giveaways.curseapp.tech"; }
            }

            public override string GroupsApi
            {
                get { return "https://groups.curseapp.tech"; }
            }

            public override string Groups
            {
                get { return "https://groups.curseapp.tech"; }
            }

            public override string Invitations
            {
                get { return "https://groups.curseapp.tech"; }
            }

            public override string PrivateMessages
            {
                get { return "https://groups.curseapp.tech"; }
            }

            public override string Servers
            {
                get { return "https://groups.curseapp.tech"; }
            }

            public override string Poll
            {
                get { return "https://polls.curseapp.tech"; }
            }

            public override string Session
            {
                get { return "https://sessions.curseapp.tech"; }
            }

            public override string LinkedCommunities
            {
                get { return "https://sync.curseapp.tech"; }
            }

            public override string LinkedAccounts
            {
                get { return "https://sync.curseapp.tech"; }
            }

            public override string Login
            {
                get { return "https://logins.curseapp.tech"; }
            }

            public override string Register
            {
                get { return "https://logins.curseapp.tech"; }
            }

            public override string Stats
            {
                get { return "https://stats.curseapp.tech"; }
            }
        }

        private class ReleaseUrls : ServiceUrls
        {
            public override string Account
            {
                get { return "https://accounts-v1.curseapp.net"; }
            }

            public override string Bugs
            {
                get { return "https://bugs-v1.curseapp.net"; }
            }

            public override string Feedback
            {
                get { return "https://bugs-v1.curseapp.net"; }
            }

            public override string CallsAdmin
            {
                get { return "https://calls-v1.curseapp.net"; }
            }

            public override string Calls
            {
                get { return "https://calls-v1.curseapp.net"; }
            }

            public override string FriendSuggestions
            {
                get { return "https://contacts-v1.curseapp.net"; }
            }

            public override string FriendSync
            {
                get { return "https://contacts-v1.curseapp.net"; }
            }

            public override string Friendships
            {
                get { return "https://contacts-v1.curseapp.net"; }
            }

            public override string Contacts
            {
                get { return "https://contacts-v1.curseapp.net"; }
            }

            public override string Users
            {
                get { return "https://contacts-v1.curseapp.net"; }
            }

            public override string Conversations
            {
                get { return "https://conversations-v1.curseapp.net"; }
            }

            public override string Giveaways
            {
                get { return "https://giveaways-v1.curseapp.net"; }
            }

            public override string GroupsApi
            {
                get { return "https://groups-v1.curseapp.net"; }
            }

            public override string Groups
            {
                get { return "https://groups-v1.curseapp.net"; }
            }

            public override string Invitations
            {
                get { return "https://groups-v1.curseapp.net"; }
            }

            public override string PrivateMessages
            {
                get { return "https://groups-v1.curseapp.net"; }
            }

            public override string Servers
            {
                get { return "https://groups-v1.curseapp.net"; }
            }

            public override string Poll
            {
                get { return "https://polls-v1.curseapp.net"; }
            }

            public override string Session
            {
                get { return "https://sessions-v1.curseapp.net"; }
            }

            public override string LinkedCommunities
            {
                get { return "https://sync-v1.curseapp.net"; }
            }

            public override string LinkedAccounts
            {
                get { return "https://sync-v1.curseapp.net"; }
            }

            public override string Login
            {
                get { return "https://logins-v1.curseapp.net"; }
            }

            public override string Register
            {
                get { return "https://logins-v1.curseapp.net"; }
            }

            public override string Stats
            {
                get { return "https://stats-v1.curseapp.net"; }
            }
        }
         
        public static void SetDefaultUrls()
        {
#if CONFIG_DEBUG
            BaseServices.Urls = new DebugUrls();
#elif CONFIG_STAGING
            BaseServices.Urls = new StagingUrls();
#elif CONFIG_RELEASE
            BaseServices.Urls = new ReleaseUrls();
#endif
        }
    }
}
