using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class PushPreferencesResponse{
	public PushNotificationPreference FriendMessagePushPreference { get; set; }
	public PushNotificationPreference GroupMessagePushPreference { get; set; }
	public bool FriendRequestPushEnabled { get; set; }
	public bool MentionsPushEnabled { get; set; }
}
public class PushNotificationPreferencesRequest{
	public PushNotificationPreference GroupMessagePushPreference { get; set; }
	public PushNotificationPreference FriendMessagePushPreference { get; set; }
	public bool FriendRequestPushEnabled { get; set; }
	public bool? MentionsPushEnabled { get; set; }
}
public class ChangeStatusRequest{
	public Guid MachineKey { get; set; }
	public UserConnectionStatus Status { get; set; }
	public string CustomStatusMessage { get; set; }
}
public class ChangeGameStatusRequest{
	public int? GameID { get; set; }
	public int GameState { get; set; }
	public string GameStatusMessage { get; set; }
	public bool IsRunning { get; set; }
	public string MachineKey { get; set; }
}
public class ChangeProfileRequest{
	public string Name { get; set; }
	public string City { get; set; }
	public string State { get; set; }
	public string CountryCode { get; set; }
	public string AboutMe { get; set; }
}
public enum ChangePasswordStatus {
	InvalidOldPassword = 0,
	InvalidNewPassword = 1,
	PasswordMismatch = 2,
	Success = 3,
	Error = 4,
}
public class ChangePasswordRequest{
	public string OldPassword { get; set; }
	public string NewPassword { get; set; }
	public string ConfirmNewPassword { get; set; }
}
public enum ChangeEmailStatus {
	Successful = 0,
	EmailInUse = 1,
	InvalidEmail = 2,
	Error = 3,
	InvalidPassword = 4,
}
public class ChangeEmailRequest{
	public string Email { get; set; }
	public string Password { get; set; }
}
public class ChangeClientSettingsRequest{
	public string GlobalSettings { get; set; }
	public string WebSettings { get; set; }
	public string DesktopSettings { get; set; }
	public string MobileSettings { get; set; }
}

}
