using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class VoiceHostCallbackRequest{
	public Guid GroupID { get; set; }
	public int[] UserIDs { get; set; }
	public VoiceHostCallbackType ChangeType { get; set; }
	public string InviteCode { get; set; }
}
public enum VoiceHostCallbackType {
	CallStarted = 0,
	CallEnded = 1,
	UsersJoined = 2,
	UsersLeft = 3,
}
public class KickUsersFromCallRequest{
	public int RequestorUserID { get; set; }
	public Guid GroupID { get; set; }
	public int[] UserIDs { get; set; }
	public KickReason Reason { get; set; }
}
public enum KickReason {
	UserRemoved = 0,
	UserLeft = 1,
}
public class CheckVoicePermissionsRequest{
	public Guid GroupID { get; set; }
	public int RequestingUserID { get; set; }
	public int AffectedUserID { get; set; }
}
public class GetModerationStatusResponse{
	public VoicePermissions Permissions { get; set; }
	public bool IsMuted { get; set; }
	public bool IsDeafened { get; set; }
}
public class VoicePermissions{
	public int BestRoleRank { get; set; }
	public bool CanSpeak { get; set; }
	public bool CanModKick { get; set; }
	public bool CanModMute { get; set; }
	public bool CanModDeafen { get; set; }
}
public class ConversationCallRequest{
	public string ClientVersion { get; set; }
	public bool Force { get; set; }
	public bool SendInvitation { get; set; }
}
public class AdHocCallRequest{
	public int? GameID { get; set; }
	public string UserDisplayName { get; set; }
	public string ClientVersion { get; set; }
}
public class AdHocCallDisplayDetailsResponse{
	public int UserID { get; set; }
	public string Username { get; set; }
	public string InviteCode { get; set; }
	public long Timestamp { get; set; }
}
public class DeafenUserRequest{
	public int UserID { get; set; }
	public bool Mute { get; set; }
}
public class MoveUserRequest{
	public Guid TargetGroupID { get; set; }
}

}
