using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class FriendListSearchRequest{
	public FriendHintContract Identity { get; set; }
	public FriendHintContract[] FriendsList { get; set; }
}
public class FriendshipRequest{
	public string KnownIdentity { get; set; }
	public string InvitationMessage { get; set; }
	public bool IsFromSuggestion { get; set; }
}
public class FriendOfFriendDetails{
	public int UserID { get; set; }
	public string Username { get; set; }
}
public class FriendSearchResponse{
	public CharacterSearchContract[] CharacterMatches { get; set; }
	public EmailSearchContract[] EmailMatches { get; set; }
	public UsernameSearchContract[] UserMatches { get; set; }
	public PlatformSearchContract[] PlatformMatches { get; set; }
	public int ElapsedMilliseconds { get; set; }
	public FriendSearchStatus Status { get; set; }
}
public enum FriendSearchStatus {
	Unknown = 0,
	Successful = 1,
	Error = 2,
	Invalid = 3,
}
public class ChangeFriendshipPreferencesRequest{
	public NotificationPreference Preference { get; set; }
	public string[] FilterSet { get; set; }
}
public class ContactsResponse{
	public FriendshipContract[] Friends { get; set; }
	public GroupNotification[] Groups { get; set; }
}
public class ContactUrlResponse{
	public string ContactID { get; set; }
	public string ConversationID { get; set; }
	public string Title { get; set; }
	public string Url { get; set; }
	public ContactUrlType Type { get; set; }
	public GroupContactUrlResponse GroupContact { get; set; }
}
public enum ContactUrlType {
	Group = 0,
	Server = 1,
	Friend = 2,
}
public class GroupContactUrlResponse{
	public GroupSubType Subtype { get; set; }
	public string Description { get; set; }
	public bool IsPublic { get; set; }
	public int MemberCount { get; set; }
}

}
