using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public enum AvatarType {
	User = 1,
	Group = 2,
	SyncedAccount = 3,
	SyncedCommunity = 4,
	GroupEmoticon = 5,
	SyncedEmoticon = 6,
	GroupCover = 7,
}
public enum ConversationNotificationType {
	Normal = 0,
	Edited = 1,
	Liked = 2,
	Deleted = 3,
}
public enum CreateGroupInvitationErrorType {
	NoRequest = 0,
	Success = 1,
	LifeSpanOutOfRange = 2,
	MaxUsesOutOfRange = 3,
	AdminDescriptionOutOfRange = 4,
	NotAServer = 5,
	WrongServer = 6,
	ChannelNotAccessibleByGuests = 7,
	TooManyInvites = 8,
}
public enum ExternalCommunityLinkChangeType {
	Linked = 0,
	Unlinked = 1,
	LiveStatus = 2,
}
public enum FriendRequestPrivacy {
	Anyone = 0,
	FriendsOfFriends = 1,
	NoOne = 2,
}
public enum CallResponseReason {
	Accepted = 0,
	Declined = 1,
}
public enum CallType {
	AdHoc = 1,
	AutoMatch = 2,
	Friend = 3,
	Group = 4,
	MultiFriend = 5,
}
public enum ContentTag {
	Image = 1,
	Video = 2,
	Hyperlink = 3,
	File = 4,
}
public enum ConversationEntryType {
	Message = 0,
	Notification = 1,
}
public enum ConversationType {
	Friendship = 0,
	Group = 1,
	AdHoc = 2,
	GroupPrivateConversation = 3,
}
public enum DevicePlatform {
	Windows = 0,
	Mac = 1,
	iOS = 2,
	Android = 3,
	WindowsPhone = 4,
	Blackberry = 5,
	Chrome = 6,
	Unknown = 7,
}
public enum EmoticonSource {
	Curse = 0,
	Twitch = 1,
}
public enum AccountType {
	Curse = 0,
	Twitch = 1,
	YouTube = 2,
}
public enum FriendHintStatus {
	Normal = 0,
	Deleted = 1,
}
public enum FriendHintType {
	Unknown = 0,
	CentralID = 1,
	Username = 2,
	Email = 3,
	Site = 4,
	Game = 5,
	Platform = 6,
}
public enum FriendHintVerification {
	Unknown = 0,
	ManualEntry = 1,
	ClientSubmitted = 100,
	ClientObserved = 200,
	Verified = 300,
}
public enum FriendHintVisibility {
	VisibleToFriends = 0,
	VisibleToEveryone = 1,
	Hidden = 2,
}
public enum FriendPlatform {
	Unknown = 0,
	BattleNet = 1,
	Steam = 2,
	Facebook = 3,
	Skype = 4,
}
public class FriendPlatformExtensions{
}
public enum FriendshipRequestAvailability {
	Allowed = 0,
	NotAllowed = 1,
	NoMutualFriends = 2,
}
public enum FriendshipStatus {
	AwaitingMe = 0,
	AwaitingThem = 1,
	Confirmed = 2,
	DeclinedByMe = 3,
	DeclinedByThem = 4,
	Removing = 5,
	Deleted = 6,
}
public enum FriendSuggestionType {
	MutualFriend = 0,
	GameFriend = 1,
	PlatformFriend = 2,
}
public enum FriendSuggestionStatus {
	Pending = 0,
	Declined = 1,
	Accepted = 2,
}
public enum GroupBannedUserSortType {
	Username = 0,
	Date = 1,
	Reason = 2,
	Requestor = 3,
}
public enum GroupChangeType {
	Unknown = 0,
	CreateGroup = 1,
	AddUsers = 2,
	RemoveUsers = 3,
	UpdateUsers = 4,
	ChangeInfo = 5,
	VoiceSessionStarted = 6,
	VoiceSessionEnded = 7,
	VoiceSessionUserJoined = 8,
	VoiceSessionUserLeft = 9,
	RemoveGroup = 10,
	GroupReorganized = 11,
	PermissionsChanged = 12,
	RoleNamesChanged = 13,
	UpdateEmoticons = 14,
}
public enum GroupEventChannelChangeFlags {
	None = 0,
	Title = 1,
	Motd = 2,
	Permissions = 4,
	Access = 8,
}
public enum GroupEventCommunityChangeFlags {
	None = 0,
	SyncEmotes = 1,
	GracePeriod = 2,
}
public enum GroupEventRoleChangeFlags {
	None = 0,
	Name = 1,
	Rank = 2,
	Permissions = 4,
	Color = 8,
	Badge = 16,
}
public enum GroupEventRootChangeFlags {
	None = 0,
	Title = 1,
	Motd = 2,
	VoiceRegion = 4,
	AfkTimer = 8,
	Access = 16,
	ChatThrottle = 32,
	SearchSettings = 64,
}
public enum GroupEventCategory {
	Group = 0,
	User = 1,
	Giveaway = 2,
	Poll = 3,
	CommunityLink = 4,
	Role = 5,
	Channel = 6,
}
public enum GroupEventType {
	GroupCreated = 1,
	GroupDeleted = 2,
	GroupSettingsChanged = 3,
	UsersAdded = 2001,
	UsersRemoved = 2002,
	UserRolesAdded = 2003,
	UserRolesRemoved = 2004,
	GiveawayStarted = 3001,
	GiveawayRoll = 3002,
	GiveawayEnded = 3003,
	PollStarted = 4001,
	PollEnded = 4002,
	CommunityLinked = 5001,
	CommunityUnlinked = 5002,
	CommunitySettingsChanged = 5003,
	ChannelCreated = 6001,
	ChannelRemoved = 6002,
	ChannelInfoChanged = 6003,
	RoleAdded = 7001,
	RoleRemoved = 7002,
	RoleInfoChanged = 7003,
}
public enum GroupGiveawayChangeType {
	Unknown = 0,
	Started = 1,
	Ended = 2,
	Removed = 3,
	ParticipantAdded = 4,
	ParticipantRemoved = 5,
	WinnerSelected = 6,
	InvalidWinnerSelected = 7,
	PrizeClaimed = 8,
	ClaimExpired = 9,
	EntriesUpdated = 10,
	InvalidRoll = 11,
	FakeRoll = 12,
	Rolling = 13,
}
public enum GroupGiveawayRollStatus {
	Pending = 0,
	Invalid = 1,
	Claimed = 2,
	ClaimExpired = 3,
	Fake = 4,
}
public enum GroupGiveawayStatus {
	Active = 0,
	Rolling = 1,
	WaitingForClaim = 2,
	Claimed = 3,
	Ended = 4,
	Inactive = 5,
}
public enum GroupInvitationStatus {
	Active = 0,
	Invalid = 1,
	Defunct = 2,
}
public enum GroupMemberSearchSortType {
	Default = 0,
	Role = 1,
	Username = 2,
	DateJoined = 3,
	DateLastActive = 4,
}
public enum GroupMembershipStatus {
	Subscribed = 0,
	Unsubscribed = 1,
}
public enum GroupMode {
	TextAndVoice = 0,
	TextOnly = 1,
}
public enum GroupPermissions {
	None = 0,
	All = -1,
	Access = 1,
	ManageServer = 2,
	ManageChannels = 4,
	CreateTemporaryGroup = 8,
	AccessAdminPanel = 16,
	InviteUsers = 32,
	RemoveUser = 64,
	ManageInvitations = 128,
	ChangeUserRole = 256,
	BanUser = 512,
	VoiceKickUser = 1024,
	VoiceMuteUser = 2048,
	VoiceDeafenUser = 4096,
	VoiceSpeak = 8192,
	VoiceMoveUser = 16384,
	VoiceChangeSettings = 32768,
	ChatSendMessages = 65536,
	ChatEmbedLinks = 131072,
	ChatUploadPhotos = 262144,
	ChatAttachFiles = 524288,
	ChatReadHistory = 1048576,
	ChatMentionUsers = 2097152,
	ChatMentionEveryone = 4194304,
	ChatBypassChatThrottle = 268435456,
	ChatModerateMessages = 8388608,
	SendPrivateMessage = 16777216,
	ManagePolls = 33554432,
	ManageGiveaways = 67108864,
}
public enum GroupPermissionState {
	Allowed = 0,
	AllowedInherited = 1,
	NotAllowed = 2,
	NotAllowedInherited = 3,
}
public enum GroupPollChangeType {
	Started = 0,
	Ended = 1,
	VotesUpdated = 2,
	Deactivated = 3,
}
public enum GroupPollDisplayType {
	BarGraph = 0,
	PieChart = 1,
}
public enum GroupPollDuplicateMode {
	Legacy = 0,
	PreventByUserID = 1,
	PreventByIP = 2,
	PreventByCookie = 3,
	AllowDuplicates = 4,
}
public enum GroupPollStatus {
	Starting = 0,
	Running = 1,
	Ended = 2,
	Inactive = 3,
}
public enum GroupMemberRemovedReason {
	Left = 0,
	Kicked = 1,
	Banned = 2,
}
public enum GroupRoleSource {
	Curse = 0,
	Twitch = 1,
	YouTube = 2,
}
public enum GroupRoleTag {
	None = 0,
	SyncedFollower = 1,
	SyncedSubscriber = 2,
	SyncedModerator = 3,
	SyncedOwner = 4,
}
public enum GroupSearchSortType {
	Default = 0,
	Title = 1,
	MemberCount = 2,
	DateStreaming = 3,
	DateFeatured = 4,
}
public enum GroupSearchTag {
	Casual = 0,
	Hardcore = 1,
	Competitive = 2,
	LFM = 3,
	Twitch = 4,
	YouTube = 5,
	Guild = 6,
}
public enum GroupSubType {
	Custom = 0,
	Guild = 1,
	Stream = 2,
}
public enum GroupSuggestionStatus {
	Pending = 0,
	Declined = 1,
	Accepted = 2,
	Invalid = 3,
}
public enum GroupSuggestionType {
	ExternalAccountSync = 0,
}
public enum GuildServerCreationErrorType {
	NoError = 0,
	TitleLength = 1,
	OwnerRoleMissing = 2,
	OwnerRoleNameLength = 3,
	GuestRoleMissing = 4,
	GuestRoleNameLength = 5,
	AdditionalRoleNameLength = 6,
	GeneralChatNameLength = 7,
	OfficerChatNameLength = 8,
	PveChatNameLength = 9,
	PvpChatNameLength = 10,
}
public enum GroupStatus {
	Normal = 0,
	Deleted = 1,
}
public enum GroupType {
	Normal = 0,
	Large = 1,
	Temporary = 2,
}
public enum HostEnvironment {
	Unknown = 0,
	Debug = 1,
	Staging = 2,
	Beta = 3,
	Release = 4,
}
public enum NotificationPreference {
	Enabled = 0,
	Disabled = 1,
	Filtered = 2,
}
public enum PrivateMessagePrivacy {
	Anyone = 0,
	FriendsOnly = 1,
	OnlyContactedUsers = 2,
}
public enum PushNotificationPreference {
	All = 0,
	Favorites = 1,
	None = 2,
}
public enum PushNotificationType {
	Unknown = 0,
	InstantMessage = 1,
	GroupMessage = 2,
	FriendRequest = 3,
	FriendConfirmation = 4,
	IncomingCall = 5,
	ConversationMessage = 6,
}
public enum SyncedMemberGracePeriodAction {
	None = 0,
	RemoveRoles = 1,
	RemoveMember = 2,
}
public enum UserConnectionStatus {
	Offline = 0,
	Online = 1,
	Away = 2,
	Invisible = 3,
	Idle = 4,
	DoNotDisturb = 5,
}
public enum VoiceRegion {
	Default = 0,
	NorthAmericaEast = 1,
	NorthAmericaWest = 2,
	EuropeWest = 3,
	AsiaSouth = 4,
	AsiaNorth = 5,
	Oceania = 6,
	SouthAmerica = 7,
	CanadaEast = 8,
	EuropeNordicAndEast = 10,
}

}
