using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class CreateGroupRequest{
	public int[] RecipientsUserIDs { get; set; }
	public string Title { get; set; }
	public string OwnerRoleName { get; set; }
	public string MemberRoleName { get; set; }
}
public class ModifyGroupSettingsRequest{
	public string Title { get; set; }
	public string MessageOfTheDay { get; set; }
	public bool? ForcePushToTalk { get; set; }
}
public class GroupMemberSearchRequest{
	public string Username { get; set; }
	public int? RoleID { get; set; }
	public int? PageSize { get; set; }
	public int? Page { get; set; }
	public GroupMemberSearchSortType? SortType { get; set; }
	public bool? SortAscending { get; set; }
}
public class GroupNotificationPreferences{
	public NotificationPreference Preference { get; set; }
	public string[] FilterSet { get; set; }
}
public class GetInvitationDisplayDetailsResponse{
	public string InviteCode { get; set; }
	public Guid GroupID { get; set; }
	public string GroupTitle { get; set; }
	public Guid ChannelID { get; set; }
	public string ChannelTitle { get; set; }
	public int CreatorID { get; set; }
	public string CreatorUsername { get; set; }
	public int MemberCount { get; set; }
	public string Description { get; set; }
}
public class GroupInvitationRedeemResponse{
	public GroupNotification Group { get; set; }
	public Guid ChannelID { get; set; }
}
public class SearchServersRequest{
	public string Query { get; set; }
	public int? PageNumber { get; set; }
	public int? PageSize { get; set; }
	public string GroupTitle { get; set; }
	public string OwnerUsername { get; set; }
	public int? MinMemberCount { get; set; }
	public int? MaxMemberCount { get; set; }
	public GroupSearchTag[] Tags { get; set; }
	public bool? IsPublic { get; set; }
	public int[] Games { get; set; }
	public GroupSearchSortType? SortType { get; set; }
	public bool? SortAscending { get; set; }
	public bool? IsFeatured { get; set; }
	public bool? IsStreaming { get; set; }
}
public class CreateServerRequest{
	public string Title { get; set; }
	public string TextChannelTitle { get; set; }
	public string VoiceChannelTitle { get; set; }
	public string OwnerRoleName { get; set; }
	public string GuestRoleName { get; set; }
	public string ModeratorRoleName { get; set; }
	public bool IsPublic { get; set; }
}
public class CreateStreamerCommunityGroupResponse{
	public GroupNotification Group { get; set; }
	public SyncResults[] SyncedStreams { get; set; }
}
public class SyncResults{
	public string StreamID { get; set; }
	public AccountType Type { get; set; }
	public bool Succeeded { get; set; }
	public int Followers { get; set; }
	public int Subscribers { get; set; }
}
public class CreateStreamerCommunityGroupRequest{
	public string ServerName { get; set; }
	public string DefaultTextChannelName { get; set; }
	public string DefaultVoiceChannelName { get; set; }
	public string OwnerRoleName { get; set; }
	public string GuestRoleName { get; set; }
	public bool IsPublic { get; set; }
	public string CustomUrl { get; set; }
	public SyncedStreamInfo[] SyncedStreams { get; set; }
}
public class SyncedStreamInfo{
	public string ExternalAccountID { get; set; }
	public AccountType Type { get; set; }
	public string PremiumChannelName { get; set; }
}
public class CreateGuildCommunityRequest{
	public string Title { get; set; }
	public bool IsPublic { get; set; }
	public int[] Games { get; set; }
	public GuildCommunityRoleContract OwnerRole { get; set; }
	public GuildCommunityRoleContract GuestRole { get; set; }
	public GuildCommunityRoleContract[] AdditionalRoles { get; set; }
	public string GeneralChatName { get; set; }
	public string OfficerChatName { get; set; }
	public string PveChatName { get; set; }
	public string PvpChatName { get; set; }
}
public class GuildCommunityRoleContract{
	public string Name { get; set; }
	public int Color { get; set; }
	public bool IsOfficer { get; set; }
}
public enum ValidateUrlStatus {
	Invalid = 0,
	Taken = 1,
	Available = 2,
}
public class ServerGeneralSettingsContract{
	public string Title { get; set; }
	public Guid? AfkChannel { get; set; }
	public int AfkTimeMinutes { get; set; }
	public VoiceRegion VoiceRegion { get; set; }
	public bool IsPublic { get; set; }
	public int ChatThrottleSeconds { get; set; }
	public bool ChatThrottleEnabled { get; set; }
}
public class ServerSearchSettingsContract{
	public bool IsSearchable { get; set; }
	public string Description { get; set; }
	public GroupSearchTag[] SearchTags { get; set; }
	public int[] Games { get; set; }
	public bool MatchAllGames { get; set; }
}
public class CreateChannelRequest{
	public string Title { get; set; }
	public GroupMode Mode { get; set; }
	public bool IsPublic { get; set; }
	public int[] AccessRoles { get; set; }
}
public class ModifyChannelSettingsRequest{
	public string Title { get; set; }
	public string MessageOfTheDay { get; set; }
	public bool? AllowTemporaryChildGroups { get; set; }
	public bool? ForcePushToTalk { get; set; }
	public bool IsPublic { get; set; }
	public int[] AccessRoles { get; set; }
}
public class ReorganizeGroupRequest{
	public GroupStructure RootGroup { get; set; }
}
public class GroupStructure{
	public Guid GroupID { get; set; }
	public GroupStructure[] OrderedChildren { get; set; }
}
public class AddEmoticonRequest{
	public string Regex { get; set; }
	public string Url { get; set; }
	public int[] RequiredRoles { get; set; }
}
public class GroupRoleDetails{
	public GroupRoleNotification Role { get; set; }
	public Dictionary<Guid, long>  EffectivePermissions { get; set; }
	public Dictionary<Guid, Dictionary<GroupPermissions, GroupPermissionState> >  Permissions { get; set; }
}
public class CreateGroupRoleRequest{
	public string Name { get; set; }
	public int VanityColor { get; set; }
	public int VanityBadge { get; set; }
	public bool HasCustomVanityBadge { get; set; }
	public GroupPermissions Permissions { get; set; }
}
public class ModifyGroupRoleRequest{
	public string Name { get; set; }
	public int VanityColor { get; set; }
	public int VanityBadge { get; set; }
	public bool HasCustomVanityBadge { get; set; }
	public Dictionary<GroupPermissions, GroupPermissionState>  Permissions { get; set; }
}
public class ModifyGroupRolePermissionsRequest{
	public Dictionary<GroupPermissions, GroupPermissionState>  PermissionsChanges { get; set; }
}
public class CreateGroupInviteRequest{
	public Guid ChannelID { get; set; }
	public bool AutoRemoveMembers { get; set; }
	public int LifespanMinutes { get; set; }
	public int MaxUses { get; set; }
	public string AdminDescription { get; set; }
}
public class GroupBannedUserContract{
	public Guid GroupID { get; set; }
	public string GroupTitle { get; set; }
	public int UserID { get; set; }
	public string Username { get; set; }
	public int RequestorUserID { get; set; }
	public string RequestorUsername { get; set; }
	public long StatusTimestamp { get; set; }
	public string Reason { get; set; }
	public bool IsBanned { get; set; }
}
public class SearchBannedUsersRequest{
	public int? PageNumber { get; set; }
	public int? PageSize { get; set; }
	public string Query { get; set; }
	public string Username { get; set; }
	public string RequestorUsername { get; set; }
	public string Reason { get; set; }
	public GroupBannedUserSortType? SortType { get; set; }
	public bool? SortAscending { get; set; }
}

}
