using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class LoginResponse{
	public LoginStatus Status { get; set; }
	public string StatusMessage { get; set; }
	public LoginSession Session { get; set; }
}
public enum LoginStatus {
	Success = 1,
	UnauthorizedLogin = 3,
	InvalidPassword = 4,
	UnknownUsername = 5,
	UnknownEmail = 6,
	CorruptLibrary = 102,
	SubscriptionMismatch = 104,
	SubscriptionExpired = 105,
	MissingGrant = 108,
	GeneralError = 1000,
}
public class LoginSession{
	public int UserID { get; set; }
	public string Username { get; set; }
	public string SessionID { get; set; }
	public string Token { get; set; }
	public string EmailAddress { get; set; }
	public bool EffectivePremiumStatus { get; set; }
	public bool ActualPremiumStatus { get; set; }
	public int SubscriptionToken { get; set; }
	public long Expires { get; set; }
	public long RenewAfter { get; set; }
	public bool IsTemporaryAccount { get; set; }
}
public class LoginRequest{
	public string Username { get; set; }
	public string Password { get; set; }
}
public class RenewTokenResponseContract{
	public string Token { get; set; }
	public long Expires { get; set; }
	public long RenewAfter { get; set; }
}
public class LoginWithNetworkSessionRequest{
	public int SiteID { get; set; }
	public string SessionID { get; set; }
}
public class RegisterResponse{
	public RegisterStatus Status { get; set; }
	public string StatusMessage { get; set; }
	public LoginSession Session { get; set; }
}
public enum RegisterStatus {
	Success = 0,
	EmailInUse = 1,
	UsernameInUse = 2,
	InvalidEmail = 3,
	InvalidProfile = 4,
	InvalidUsername = 5,
	InvalidPassword = 6,
	GeneralError = 7,
	TooManyAccountsSameIp = 8,
}
public class RegisterRequest{
	public string Username { get; set; }
	public string Password { get; set; }
	public string Email { get; set; }
	public bool Newsletter { get; set; }
}
public class RegisterTempResponse{
	public string TempAccountToken { get; set; }
	public RegisterStatus Status { get; set; }
	public string StatusMessage { get; set; }
	public LoginSession Session { get; set; }
}
public class RegisterTempRequest{
	public string Username { get; set; }
}
public class ClaimTempRequest{
	public string TempAccountToken { get; set; }
	public string Email { get; set; }
	public string Password { get; set; }
}

}
