using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class ActivePollContract{
	public GroupPollNotification Poll { get; set; }
	public int[] MyVotes { get; set; }
}
public class CreatePollRequest{
	public string Title { get; set; }
	public Dictionary<int, string>  Options { get; set; }
	public GroupPollDisplayType DisplayType { get; set; }
	public int[] RequiredRoles { get; set; }
	public int DurationMinutes { get; set; }
	public bool AllowMultiSelect { get; set; }
	public bool IsPublic { get; set; }
	public bool AllowRevotes { get; set; }
	public GroupPollDuplicateMode DuplicateMode { get; set; }
}
public class GroupPollResult{
	public Guid GroupID { get; set; }
	public int PollID { get; set; }
	public string Title { get; set; }
	public int[] RequiredRoles { get; set; }
	public long DurationMinutes { get; set; }
	public long DateEnded { get; set; }
	public int TotalVotes { get; set; }
	public int TotalOptions { get; set; }
	public string[] WinningOptions { get; set; }
}
public class SearchPollHistoryRequest{
	public int? PageSize { get; set; }
	public int? PageNumber { get; set; }
}
public class PublicActivePollContract{
	public GroupNotification Group { get; set; }
	public GroupPollNotification Poll { get; set; }
	public int[] MyVotes { get; set; }
}

}
