﻿using System;
using System.Collections.Generic;
using Curse.ServiceClients;
using Curse.ServiceEncryption;

namespace Curse.Voice.ServiceClients
{
    internal class TokenProvider : IServicesTokenProvider
    {
        private static string _apiKey;

        public static void Initialize(string apiKey)
        {
            _apiKey = apiKey;
        }

        public string GetToken()
        {
            return EncryptionToken.FromDictonary(new Dictionary<string, string>
            {
                {"ApiKey", _apiKey},
                {"Timestamp", EncryptionToken.ConvertToEpoch(DateTime.UtcNow).ToString()}
            }).Value;
        }
    }
}
