﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.ServiceClients;

namespace Curse.Voice.ServiceClients
{
    public class CloudServiceClients : BaseServices
    {
        static CloudServiceClients()
        {
            // Encryption done outside of this class
            ServicesConfiguration.SetDefaultUrls();            
            ServicesConfiguration.TokenProvider = new TokenProvider();
            ServicesConfiguration.LogProvider = new LogProvider();
        }

        public static void Initialize(string apiKey)
        {
            TokenProvider.Initialize(apiKey);
        }

        public static CloudServiceClients Instance { get { return Nested.Instance; } }

        private class Nested
        {
            // Explicit static constructor to tell C# compiler
            // not to mark type as beforefieldinit
            static Nested()
            {
            }

            internal static readonly CloudServiceClients Instance = new CloudServiceClients();
        }
    }
}
