﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;


namespace Curse.Voice.Tests
{
    public static class ClientLogin
    {        
        private static readonly string _localEncryptionSeed = "31ED549B43318C9CFAE926ADE1720D2202C2DEFFAB06AE9D78FB6F16DF2D70A4";
        private static readonly string _outgoingEncryptionSeed = "31ED549B43318C9CFAE926ADE1720D2202C2DEFFAB06AE9D78FB6F16DF2D70A4";
        private static readonly StringCipher _localCipher;
        private static readonly StringCipher _outgoingCipher;

        static ClientLogin()
        {
            _localCipher = new StringCipher(_localEncryptionSeed);
            _outgoingCipher = new StringCipher(_outgoingEncryptionSeed);
        }

        public static string EncryptLocalString(string value)
        {
            return _localCipher.Encrypt(value);
        }

        public static string EncryptOutgoingString(string value)
        {
            return _outgoingCipher.Encrypt(value);
        }

        public static string DecryptLocalString(string value)
        {
            string unencrypted = value;
            try
            {
                unencrypted = _localCipher.Decrypt(value);
            }
            catch { }
            return unencrypted;
        }

    }
}