﻿using Curse.Voice.HostManagement.Responses;
using Curse.Voice.Tests;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Voice.Tests.VoiceService;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Diagnostics;
using Curse.Voice.Contracts;
using Curse.Voice.HostManagement;

namespace Curse.Voice.Tests
{
    class Program
    {
        
        private const string Username = "zusername";
        private const string Password = "password";

        public static CurseVoiceServiceClient GetClient()
        {
                        
            string encryptedPassword = ClientLogin.EncryptOutgoingString(Password);

            // Set the authentication context
            AuthToken.Outgoing = new AuthToken(Username, encryptedPassword);
            
            // Create the client
            CurseVoiceServiceClient client = new CurseVoiceServiceClient("BasicHttpBinding_ICurseVoiceService");

            // Add the behaviour to send the credentials with each request
            client.ChannelFactory.Endpoint.Behaviors.Add(new AuthTokenExtension());

            //Logger.Log("WCF client has been created for endpoint at: '{0}'", ELogLevel.Info, serviceUri.AbsoluteUri);

            return client;
        }

        static void Main(string[] args)
        {


            var client = new VoiceManagementClient(new InstanceContext(new VoiceHostCallbackClient()), "michael-win8.curse.us", 81);
            int numberToProvision = 10;

            Console.WriteLine("Provisioning " + numberToProvision.ToString("###,##0") + " instances");
            for (int i = 1; i <= numberToProvision; i++)
            {
                var resp = client.ProvisionTypedVoiceInstance("Test-" + i.ToString(), 1, VoiceInstanceType.AdHoc,  "");
                if (resp.Status != ProvisionInstanceStatus.Successful)
                {
                    Console.WriteLine("Failed to create instance: " + resp.Status.ToString());
                }
                else
                {
                    Console.WriteLine("Successfully created " + i.ToString("###,##0"));
                }
            }
            
            Console.WriteLine("Press any key destroy them!");
            Console.ReadKey();

            for (int i = 1; i <= numberToProvision; i++)
            {
                var resp = client.DestroyVoiceInstance("Test-" + i.ToString(), "");
                if (resp.Status != DestoryInstanceStatus.Successful)
                {
                    Console.WriteLine("Failed to create instance: " + resp.Status.ToString());
                }
                else
                {
                    Console.WriteLine("Successfully destroyed " + i.ToString("###,##0"));
                }
            }
            client.Close();

            //CurseVoiceServiceClient voiceClient = GetClient();
            //var resp = client.CreateVoiceSession("Adamar", null);

            Console.WriteLine("Done! Press any key to exit....");
            Console.ReadKey();

        }
    }
}
