﻿using System;
using System.Collections.Generic;
using System.IO;

namespace Curse.Voice.UpdateDeployment.Tests
{
    public class MockConsole : IConsole
    {
        private readonly Stream _outStream = new MemoryStream();
        private readonly StreamWriter _writer;
        private readonly StreamReader _reader;
        private readonly Queue<ConsoleKeyInfo> _keys = new Queue<ConsoleKeyInfo>();

        public MockConsole()
        {
            _writer = new StreamWriter(_outStream);
            _reader = new StreamReader(_outStream);
        }

        public MockConsole TestSetUserInput(params ConsoleKeyInfo[] keys)
        {
            foreach (var key in keys)
            {
                _keys.Enqueue(key);
            }
            return this;
        }

        public string TestReadToEnd()
        {
            return _reader.ReadToEnd();
        }

        public string TestReadLine()
        {
            return _reader.ReadLine();
        }

        public ConsoleColor ForegroundColor { get; set; }

        public void ResetColor()
        {
            ForegroundColor = ConsoleColor.Gray;
        }

        public void Write(string value)
        {
            _writer.Write(value);
        }

        public void WriteLine(string value)
        {
            _writer.WriteLine(value);
        }

        public ConsoleKeyInfo ReadKey(bool intercept)
        {
            return _keys.Dequeue();
        }

        public string ReadLine()
        {
            throw new NotImplementedException();
        }
    }
}

