﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace Curse.Voice.UpdateDeployment
{
    [Serializable]
    public class AppManifest
    {
        [XmlElement("ExecutableFilename")]
        public string ExecutableFilename
        {
            get;
            set;
        }

        [XmlArray("Versions")]
        public List<AppVersion> Versions { get; set; }

        public static AppManifest Deserialize(byte[] data)
        {
            AppManifest manifest = null;
            XmlSerializer serializer = new XmlSerializer(typeof(AppManifest));

            using (var ms = new MemoryStream(data))
            {
                manifest = (AppManifest)serializer.Deserialize(ms);
            }

            return manifest;
        }

        public void Serialize(string filePath)
        {
            var serializer = new XmlSerializer(typeof(AppManifest));
            using (var sw = new StreamWriter(filePath))
            {
                serializer.Serialize(sw, this);
            }
        }
    }
    [Serializable]
    public class AppVersion
    {
        [XmlElement("Version")]
        public string VersionString { get; set; }

        public Version Version
        {
            get
            {
                return new Version(VersionString);
            }
        }

        [XmlElement("ReleaseType")]
        public AppReleaseType ReleaseType { get; set; }

    }

    public enum AppReleaseType
    {
        Release = 0,
        Beta,
        Alpha,
        Debug
    }
    
    [Serializable]
    public class AppUpdate
    {
        [XmlElement("Version")]
        public string CurrentVersion { get; set; }
        public AppReleaseType ReleaseType { get; set; }
        public string MainExectuable { get; set; }
        [XmlArray("Files")]
        [XmlArrayItem("File")]
        public List<AppUpdateFile> Files { get; set; }
        
        #region Serialize / Desrialize
        public void Serialize(string output)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(AppUpdate));
            StreamWriter sw = new StreamWriter(output);
            serializer.Serialize(sw, this);
            sw.Close();
        }

        public static AppUpdate Deserialize(byte[] data)
        {
            AppUpdate appUpdate = null;
            XmlSerializer serializer = new XmlSerializer(typeof(AppUpdate));

            MemoryStream ms = new MemoryStream(data);
            appUpdate = (AppUpdate)serializer.Deserialize(ms);
            ms.Close();
            return appUpdate;
        }
        #endregion
    }
    [Serializable]
    public class AppUpdateFile
    {
        [XmlAttribute("Name")]
        public string Name { get; set; }
        [XmlAttribute("Hash")]
        public string Hash { get; set; }
        [XmlIgnore]
        public bool NeedsUpdate { get; set; }
    }
}
