﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Voice.UpdateDeployment
{
    public static class ConsoleHelper
    {
        public static IConsole Console = new ConsoleProxy();

        public static bool PromptUserToConfirm(string promptText)
        {
            return PromptUser(promptText, new[] { ConsoleKey.Y, ConsoleKey.N }) == ConsoleKey.Y;
        }

        public static ConsoleKey PromptUser(string promptText, ConsoleKey[] options)
        {
            Console.ForegroundColor = ConsoleColor.Cyan;
            Console.Write(promptText);
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.Write(" [");

            for (int i = 0; i < options.Length; i++)
            {
                if (i > 0)
                {
                    Console.Write("/");
                }
                Console.Write(options[i].ToString());
            }
            Console.WriteLine("]");
            Console.ResetColor();
            var resp = Console.ReadKey(true);


            while (true)
            {
                if (options.Contains(resp.Key))
                {
                    break;
                }

                Console.WriteLine("Unknown Response. Please enter a valid option.");
                resp = Console.ReadKey(true);
            }

            return resp.Key;
        }

        public static string PromptUser(string promptText)
        {
            Console.ForegroundColor = ConsoleColor.Cyan;
            Console.Write(promptText);
            Console.ResetColor();
            return Console.ReadLine();
        }
    }
}
