﻿using System;
using System.Linq;

namespace Curse.Voice.UpdateDeployment
{
    public interface IConsole
    {
        ConsoleColor ForegroundColor { get; set; }
        void ResetColor();

        void Write(string mesvaluesage);
        void WriteLine(string value);

        string ReadLine();
        ConsoleKeyInfo ReadKey(bool intercept);
    }

    public class ConsoleProxy : IConsole
    {
        public ConsoleColor ForegroundColor
        {
            get { return Console.ForegroundColor; }
            set { Console.ForegroundColor = value; }
        }

        public void ResetColor() => Console.ResetColor();
        public void Write(string value) => Console.Write(value);
        public void WriteLine(string value) => Console.WriteLine(value);
        public string ReadLine() => Console.ReadLine();
        public ConsoleKeyInfo ReadKey(bool intercept) => Console.ReadKey(intercept);
    }
}
