﻿using System;

namespace Curse.Voice.UpdateDeployment
{
    public static class DateTimeExtensions
    {
        private static readonly DateTime UnixEpoch = new DateTime(1970, 1, 1);
        public static TimeSpan ToUnixTime(this DateTime dateTime) => dateTime.ToUniversalTime().Subtract(UnixEpoch);
        public static long ToUnixMilliseconds(this DateTime dateTime) => (long)dateTime.ToUnixTime().TotalMilliseconds;

        public static DateTime GetPacificTimeNow()
        {
            var pacificTimeZone = TimeZoneInfo.FindSystemTimeZoneById("Pacific Standard Time");
            return TimeZoneInfo.ConvertTimeFromUtc(DateTime.UtcNow, pacificTimeZone);
        }
    }
}
