﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using Limilabs.FTP.Client;

namespace Curse.Voice.UpdateDeployment
{
    public class FtpEndpoint
    {
        public string SourceFolder { get; set; }
        public string Host { get; set; }
        public string Path { get; set; }
        public string Username { get; set; }
        public string Password { get; set; }

        public FtpEndpoint(string sourceFolder, string host, string path, string username, string password)
        {
            SourceFolder = sourceFolder;
            Host = host;
            Path = path;
            Username = username;
            Password = password;
        }
    }
    public static class FtpWhitelisting
    {
        public static void UploadFiles(string sourceFolder, string host, string path, string username, string password, List<string> files)
        {
            try
            {
                var str = "Uploading files to antivirus: " + host;
                Console.Write(str);
                using (Ftp ftp = new Ftp())
                {
                    ftp.Connect(host);
                    ftp.Login(username, password);

                    Cleanup(ftp, path);

                    var i = 0;
                    foreach (var name in files)
                    {
                        var file = new FileInfo(Path.Combine(sourceFolder, name));
                        if (!file.Exists)
                        {
                            throw new Exception("Missing file for whitelist: " + name);
                        }
                        var fileStr = "\r" + str + "..." + i + " of " + files.Count + " > " + file.Name + "                                                ";
                        UploadFile(fileStr, file, sourceFolder, ftp, path);
                        i++;
                    }

                    ftp.Close();
                }
                Console.WriteLine("\r" + str + "...DONE                                           ");
            }
            catch (Exception ex)
            {
                throw new Exception("Failed to upload files to " + host + Environment.NewLine + ex);
            }
        }

        private static void UploadFile(string str, FileInfo file, string sourceFolder, Ftp ftp, string path)
        {
            Console.Write(str);

            if (!UploadFile(sourceFolder, ftp, file, path))
            {
                if (ConsoleHelper.PromptUser(file.Name + " failed. Try again?", new[] { ConsoleKey.Y, ConsoleKey.N }) == ConsoleKey.N)
                {
                    throw new Exception("Deploy cancelled!");
                }
                UploadFile(str, file, sourceFolder, ftp, path);
            }
        }

        private static bool UploadFile(string sourceFolder, Ftp ftp, FileInfo file, string path = null, int retryCount = 0)
        {
            if (retryCount == 3)
            {
                Console.WriteLine("3 tries to upload " + file.Name + " failed");
                return false;
            }

            try
            {
                string relativePath = file.FullName.Remove(0, sourceFolder.Length + 1);
                relativePath = (path != null ? path + "/" : "") + relativePath.Replace("\\", "/");

                if (relativePath.Contains("/"))
                {
                    var folderPath = Path.GetDirectoryName(relativePath);
                    folderPath = folderPath.Replace("\\", "/");
                    CreateFolder(ftp, folderPath);
                }

                ftp.Upload(relativePath, file.FullName);
                return true;
            }
            catch (Exception ex)
            {
                Console.WriteLine("Failed to upload file " + file.Name + " - Attempt " + retryCount + " of 3");
                return UploadFile(sourceFolder, ftp, file, path, retryCount + 1);
            }
        }

        private static void CreateFolder(Ftp ftp, string folderPath)
        {
            var path = folderPath.Split('/');
            var p = "";
            foreach (var s in path)
            {
                p += s;
                if (!ftp.FolderExists(p))
                {
                    ftp.CreateFolder(p);
                }
                p += "/";
            }
        }

        private static void Cleanup(Ftp ftp, string path)
        {
            try
            {
                var contents = ftp.GetList(path ?? "");
                foreach (var item in contents)
                {
                    if (item.IsFile)
                    {
                        ftp.DeleteFile(path + "/" + item.Name);
                    }
                    else if (item.IsFolder)
                    {
                        ftp.DeleteFolderRecursively(path + "/" + item.Name);
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
