﻿using System;
using Curse.ServiceClients;
using Curse.ServiceClients.Contracts;

namespace Curse.Voice.UpdateDeployment
{
    /// <summary>
    /// Mongoose is a service that allows you to register a client version with https://bugs.cpe.wtf/
    /// </summary>
    public class MongooseClient : BaseWebServiceClient
    {
        public MongooseClient(string url) : base(url)
        {
        }
        
        public void PublishVersion(PublishVersionRequest request)
        {
            try
            {
                var content = new
                {
                    applicationName = request.ApplicationName,
                    releaseDate = request.ReleaseDate.ToUnixMilliseconds(),
                    platform = request.Platform.ToString(),
                    releaseType = TranslateReleaseType(request.ReleaseType),
                    version = request.Version,
                };
                Post("version/update", content);
            }
            catch (Exception ex)
            {
                throw new Exception($"Mongoose->PublishVersion Failed: NonSuccessStatusCode \"{ex.Message}\"", ex);
            }
        }

        private static string TranslateReleaseType(ReleaseType releaseType)
        {
            switch (releaseType)
            {
                case ReleaseType.Alpha:
                    return "Beta";
                case ReleaseType.Beta:
                    return "Live";
                case ReleaseType.Debug:
                    return "Debug";
                case ReleaseType.Release:
                    return "Release";
                default:
                    return "Unknown";
            }
        }
      
        public class PublishVersionRequest
        {
            public string ApplicationName { get; set; }
            public DateTime ReleaseDate { get; set; }
            public DevicePlatform Platform { get; set; }
            public ReleaseType ReleaseType { get; set; }
            public string Version { get; set; }
        }
    }
}
