﻿using System.Net.Cache;
using Curse.Voice.UpdateDeployment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Curse.Voice.UpdateDeployment.HostUpdateService;
using System.Net;
using System.Threading;
using System.IO;
using System.Diagnostics;

namespace Curse.Voice.UpdateDeploymentTester
{
    class Program
    {

        static void Main(string[] args)
        {
            if (args.Contains("cloudfront"))
            {                
                CloudFrontHelper.InvalidateUrls("E22B32MVOXI04V", new[] { "/Manifest.xml", "/CurseClientSetup.exe", "/Alpha/Update.xml" });
            }

            if (args.Contains("cloudflare"))
            {


                //var result = CloudflareHelper.InvalidateUrl("cursecdn.com", "http://clientupdate-v6.cursecdn.com/CurseClientSetup.exe");                
                //Console.WriteLine("Purge " + (result ? "Succeeded!" : "Failed!"));
                Console.WriteLine("How many downloads do you want to test?");
                var res = Console.ReadLine();

                int amount = int.Parse(res);

                var folderPath = @"c:\Users\mcomperda\Downloads\CurseClientTests\";

                if (!Directory.Exists(folderPath))
                {
                    Directory.CreateDirectory(folderPath);
                }

                StringBuilder sb = new StringBuilder(10000);

                for (int i = 0; i < amount; i++)
                {
                    string urlCode = UrlShortner.RandomCharacters(4);
                    string fullUrl = "http://clientupdate-v6.cursecdn.com/CurseClientSetup.exe?h=" + urlCode;

                    using (WebClient client = new WebClient())
                    {
                        client.CachePolicy = new RequestCachePolicy(RequestCacheLevel.BypassCache);
                        var filePath = Path.Combine(folderPath, urlCode + ".exe");
                        Stopwatch sw = Stopwatch.StartNew();
                        
                        client.DownloadFile(fullUrl, filePath);
                        sw.Start();

                        TimeSpan elapsed = sw.Elapsed;
                        var fileInfo = new FileInfo(filePath);

                        sb.AppendLine("-----------------------------------------------------------------------------------------");
                        sb.AppendLine((i + 1) + ": " + fullUrl);
                        sb.AppendLine("CF-RAY: " + client.ResponseHeaders["CF-RAY"]);
                        sb.AppendLine("CF-Cache-Status: " + client.ResponseHeaders["CF-Cache-Status"]);
                        sb.AppendLine("File Size: " + fileInfo.Length.ToString("###,##0"));
                        sb.AppendLine("Download Time: " + elapsed.TotalSeconds.ToString("###,##0"));
                        sb.AppendLine("Download Speed: " + (fileInfo.Length / 1024 / elapsed.TotalSeconds) + " KB/s");
                        
                    }                    
                }

                using (StreamWriter sw = new StreamWriter("Output.txt"))
                {
                    sw.Write(sb.ToString());
                }
                Console.WriteLine("Done!");                
            }
            if (args.Contains("server"))
            {
                VoiceHostEnvironment env = VoiceHostEnvironment.Staging;

                ServerUpdateDeploymentTask task = new ServerUpdateDeploymentTask();
                task.MinimumClientVersion = "1.0.0.0";
                task.SourceFolder = @"C:\Projects\Radium\Repository\Curse.Voice\Curse.Voice.HostRuntime\bin\" + env.ToString();
                task.Environment = env.ToString();
                //task.CentralServiceUrl = "http://voice-service.cursevoice.local/HostUpdateService.svc";
                task.CentralServiceUrl = "http://voice-service.cursevoice.dev/HostUpdateService.svc";                
                task.Execute();
            }

            if (args.Contains("client"))
            {
                ClientUpdateDeploymentTask task = new ClientUpdateDeploymentTask();
                task.CentralServiceUrl = "http://voice-service.Curse.us/HostUpdateService.svc";
                task.RootSourcePath = @"C:\Curse\Updates\windows";
                task.BinPath = @"C:\Projects\Radium\Repository\Curse.Radium.Windows\bin\Alpha";
                task.DeployInstaller = false;
                task.ManifestUrl = "https://updates.curseapp.net/windows/Manifest.xml";
                task.UpdateUrl = "https://updates.curseapp.net/windows/Alpha/Update.xml";
                task.InstallerUrl = "https://updates.curseapp.net/windows/TestSetup.exe";
                task.PurgeCache = true;
                task.InstallerSourcePath = @"C:\Curse\Updates\windows\CurseClientAlphaSetup.exe";
                task.ReleaseType = "Alpha";
                task.ApplicationSourcePath = @"C:\Curse\Updates\windows\Alpha\7.0.5931.23573";
                task.ApplicationVersion = "7.0.5931.23573";
                task.AntivirusWhitelist = false;

                //task.ApplicationSourcePath = @"C:\Radium\AppUpdates\Beta\6.0.5149.29312\";
                //task.ApplicationVersion = "6.0.5149.29312";
                //task.UpdateServers = new[] { "media01a-live.curse.us", "media01b-live.curse.us", "media01c-live.curse.us" };
                //task.InstallerSourcePath = @"C:\Radium\AppUpdates\CurseClientSetup.exe";
                //task.ReleaseType = "Debug";
                //task.CentralServiceUrl = "http://service.cursevoice.dev/HostUpdateService.svc";
                //task.DeployInstaller = false;
                //task.DeployWebInstaller = true;
                //task.WebInstallerPath = @"\\smb02d-atl.curse.us\ClientService\v6\Deploys";
                task.Execute();
            }
        }
    }
}
