﻿using Curse.Voice.Helpers;
using Curse.Voice.UpdateManagement;
using System;
using System.ServiceModel;
using System.ServiceProcess;
using Curse.Voice.UpdateService.Configuration;
using Curse.Logging;


namespace Curse.Voice.UpdateService
{
    public partial class CurseVoiceUpdateService : ServiceBase
    {
        public CurseVoiceUpdateService()
        {
            InitializeComponent();
        }


        private ServiceHost _updaterServiceHost;

        protected override void OnStart(string[] args)
        {            
            Logger.Init(@"C:\Curse\Logs");
            Logger.Info("Starting Update Service");

            string endpoint = "net.tcp://0.0.0.0:" + UpdateServiceConfiguration.Instance.ListenerPortNumber + "/update-service";
            Logger.Info("Creating WCF Binding");
            _updaterServiceHost = TcpBindingHelper.CreateServiceHost<IVoiceHostUpdateListener>(new VoiceHostUpdateListener(), endpoint, true);
            Logger.Info("Opening WCF host");
            _updaterServiceHost.Open();

            Logger.Info("Update Service Started");
        }



        protected override void OnStop()
        {
            Logger.Info("Stopping Update Service");
            if (_updaterServiceHost != null)
            {
                Logger.Info("Closing WCF host"); 
                _updaterServiceHost.Close(TimeSpan.FromSeconds(5));                
                Logger.Info("WCF Host Closed");
            }
            Logger.Info("Update Service Stopped");
            Logger.Shutdown();
        }

        public void OnDebug()
        {
            OnStart(null);

        }

        public void OnDebugStop()
        {
            OnStop();
        }
    }
}
