﻿using Curse.SocketInterface;

namespace Curse.WebRTC
{
    internal static class Crc32
    {
        public static uint Compute(ByteBuffer buf, int offset, int length)
        {
            return Compute(buf.Buffer, buf.Offset + offset, length);
        }

        public static uint Compute(byte[] data, int offset, int length)
        {
            var crc = DefaultSeed;
            for (var i = offset; i < offset + length; i++)
                crc = (crc >> 8) ^ DefaultTable[data[i] ^ crc & 0xff];
            return ~crc;
        }

        private const uint DefaultPolynomial = 0xEDB88320;
        private const uint DefaultSeed = 0xFFFFFFFF;
        private static readonly uint[] DefaultTable = InitializeTable(DefaultPolynomial);

        private static uint[] InitializeTable(uint polynomial)
        {
            var createTable = new uint[256];
            for (var i = 0; i < 256; i++)
            {
                var entry = (uint)i;
                for (var j = 0; j < 8; j++)
                    if ((entry & 1) == 1)
                        entry = (entry >> 1) ^ polynomial;
                    else
                        entry = entry >> 1;
                createTable[i] = entry;
            }

            return createTable;
        }
    }
}
