﻿using System;

namespace Curse.WebRTC
{
    public static class DateTimeEx
    {
        private static readonly DateTime Epoch = new DateTime(1970, 1, 1);

        // Convert time_t value to DateTime
        public static DateTime FromTimeT(long seconds)
        {
            return Epoch + TimeSpan.FromSeconds(seconds);
        }

        // Convert DateTime to time_t value
        public static long ToTimeT(this DateTime value)
        {
            return (long)(value.ToUniversalTime() - Epoch).TotalSeconds;
        }
    }
}
