﻿using System;
using System.Runtime.ConstrainedExecution;

namespace Curse.WebRTC.OpenSSL
{
    internal class SslContext : SslSafeHandle
    {
        #region SafeHandle

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.MayFail)]
        private SslContext()
        {
        }

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.Success)]
        protected override bool ReleaseHandle()
        {
            Native.SSL_CTX_free(handle);
            handle = IntPtr.Zero;
            return true;
        }

        #endregion SafeHandle

        public static SslContext CreateDtlsServer()
        {
            return Check(Native.SSL_CTX_new(Native.DTLSv1_server_method()));
        }

        public void SetCipherList(string ciphers)
        {
            Check(Native.SSL_CTX_set_cipher_list(this, ciphers));
        }

        public void Use(SslPrivateKey key)
        {
            Check(Native.SSL_CTX_use_PrivateKey(this, key));
        }

        public void Use(SslCertificate cert)
        {
            Check(Native.SSL_CTX_use_certificate(this, cert));
        }

        public void CheckPrivateKey()
        {
            Check(Native.SSL_CTX_check_private_key(this));
        }

        public void SetTslExtUseSrtp(string profiles)
        {
            Check(Native.SSL_CTX_set_tlsext_use_srtp(this, profiles) != 1);
        }

        public void SetOptions(int arg)
        {
            Check(Native.SSL_CTX_ctrl(this, Native.SSL_CTRL_OPTIONS, arg, IntPtr.Zero));
        }
    }
}
