﻿using System;
using System.Runtime.ConstrainedExecution;

namespace Curse.WebRTC.OpenSSL
{
    internal class SslEllipticCurve : SslSafeHandle
    {
        #region SafeHandle

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.MayFail)]
        private SslEllipticCurve()
        {
        }

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.Success)]
        protected override bool ReleaseHandle()
        {
            Native.EC_KEY_free(handle);
            handle = IntPtr.Zero;
            return true;
        }

        #endregion SafeHandle

        public const int NIST_P256 = 415; // NID_X9_62_prime256v1

        public static SslEllipticCurve Generate(int nid = NIST_P256)
        {
            var curve = Check(Native.EC_KEY_new_by_curve_name(nid));

            Check(Native.EC_KEY_generate_key(curve));

            return curve;
        }
    }
}
