﻿using System;
using System.Runtime.ConstrainedExecution;

namespace Curse.WebRTC.OpenSSL
{
    internal class SslPrivateKey : SslSafeHandle
    {
        #region SafeHandle

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.MayFail)]
        private SslPrivateKey()
        {
        }

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.Success)]
        protected override bool ReleaseHandle()
        {
            Native.EVP_PKEY_free(handle);
            handle = IntPtr.Zero;
            return true;
        }

        #endregion SafeHandle

        public static SslPrivateKey GenerateElipticCurveKey()
        {
            const int EVP_PKEY_EC = 408; // NID_X9_62_id_ecPublicKey

            var curve = SslEllipticCurve.Generate();

            var pkey = Check(Native.EVP_PKEY_new());
            Check(Native.EVP_PKEY_assign(pkey, EVP_PKEY_EC, curve.DangerousGetHandle()));

            // curve is now owned by pkey
            curve.SetHandleAsInvalid();

            return pkey;
        }

        public static SslPrivateKey GenerateRsaKey(int bits = SslRsa.DefaultBits, int exp = SslRsa.DefaultExponent)
        {
            const int EVP_PKEY_RSA = 6; // NID_rsaEncryption

            var rsa = SslRsa.Generate(bits, exp);

            var pkey = Check(Native.EVP_PKEY_new());
            Check(Native.EVP_PKEY_assign(pkey, EVP_PKEY_RSA, rsa.DangerousGetHandle()));

            // rsa is now owned by pkey
            rsa.SetHandleAsInvalid();

            return pkey;
        }
    }
}
