﻿using System;
using System.Runtime.ConstrainedExecution;

namespace Curse.WebRTC.OpenSSL
{
    internal class SslRsa : SslSafeHandle
    {
        #region SafeHandle

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.MayFail)]
        private SslRsa()
        {
        }

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.Success)]
        protected override bool ReleaseHandle()
        {
            Native.RSA_free(handle);
            handle = IntPtr.Zero;
            return true;
        }

        #endregion SafeHandle

        public const int DefaultBits = 1024;
        public const int DefaultExponent = 0x10001; // = 2^16 + 1 = 65537

        public static SslRsa Generate(int bits = DefaultBits, int exponent = DefaultExponent)
        {
            var rsa = Check(Native.RSA_new());

            var bigNum = Check(Native.BN_new());
            try
            {
                Check(Native.BN_set_word(bigNum, (uint)exponent));
                Check(Native.RSA_generate_key_ex(rsa, bits, bigNum, null));
            }
            finally
            {
                Native.BN_free(bigNum);
            }

            return rsa;
        }
    }
}
