﻿using System;
using System.Runtime.ConstrainedExecution;
using System.Runtime.InteropServices;

namespace Curse.WebRTC.OpenSSL
{
    internal abstract class SslSafeHandle : SafeHandle
    {
        #region SafeHandle

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.MayFail)]
        protected SslSafeHandle()
            : base(IntPtr.Zero, true)
        {
        }

        [ReliabilityContract(Consistency.WillNotCorruptState, Cer.MayFail)]
        protected SslSafeHandle(bool ownsHandle)
            : base(IntPtr.Zero, ownsHandle)
        {
        }

        public override bool IsInvalid
        {
            [System.Security.SecurityCritical]
            get { return handle == IntPtr.Zero; }
        }

        #endregion SafeHandle

        #region Errors

        protected static T Check<T>(T result) where T : SslSafeHandle
        {
            if (result.IsInvalid)
            {
                throw new OpenSslException();
            }
            return result;
        }

        protected static IntPtr Check(IntPtr result)
        {
            if (result == IntPtr.Zero)
            {
                throw new OpenSslException();
            }
            return result;
        }

        protected static void Check(int result)
        {
            if (result == 0)
            {
                throw new OpenSslException();
            }
        }

        protected static void Check(bool result)
        {
            if (!result)
            {
                throw new OpenSslException();
            }
        }

        #endregion Errors
    }
}
