﻿namespace Curse.WebRTC.Stun
{
    // These are all known STUN attributes, defined in RFC 5389 and elsewhere.
    // Next to each is the name of the class (T is StunTAttribute) that implements
    // that type.
    // RETRANSMIT_COUNT is the number of outstanding pings without a response at
    // the time the packet is generated.
    internal enum StunAttributeType : ushort
    {
        MappedAddress = 0x0001,     // Address
        Username = 0x0006,          // ByteString
        MessageIntegrity = 0x0008,  // ByteString, 20 bytes
        ErrorCode = 0x0009,         // ErrorCode
        UnknownAttributes = 0x000a, // UInt16List
        Realm = 0x0014,             // ByteString
        Nonce = 0x0015,             // ByteString
        XorMappedAddress = 0x0020,  // XorAddress
        Priority = 0x0024,          // UInt32
        UseCandidate = 0x0025,      // empty
        Software = 0x8022,          // ByteString
        AlternateServer = 0x8023,   // Address
        Fingerprint = 0x8028,       // UInt32
        IceControlled = 0x8029,     // 8 bytes
        IceControlling = 0x802a,    // 8 bytes
        Origin = 0x802F,            // ByteString
        RetransmitCount = 0xFF00,   // UInt32
    }
}
