# Xarth Grafana Annotation Gateway

Custom Lambda that allows any account in the AWS Org to create and
update Grafana Dashboards, and create Annotations.

# What

This is a Go app and CloudFormation stack. The Go app has two endpoints:
`post /` and `patch /{id}`. The CloudFormation stack creates a Lambda and an
IAM Role that any account in the AWS Organization can `Assume` With that role,
the account can invoke the custom lambda with a dashboard or annotation payload.

# Build and Deploy

The `package` command creates and uploads the zip file to s3. It also
creates a `package.yaml` file locally that is used to deploy or update
the CloudFormation stack. The `deploy` command deploys or updates the
stack using the generated `package.yaml` file.

-   Get credentials for `twitch-grafana-dev` or `twitch-grafana-prod`. Example:

```shell
ada credentials update --account=109561199089 --profile twitch-grafana-prod --provider=isengard --role=admin --once
ada credentials update --account=963768028156 --profile twitch-grafana-dev  --provider=isengard --role=admin --once
```

-   Run these command to build and deploy to dev:

```shell
make package
make deploy
make outputs
make describe
```

-   Run these command to build and deploy to production:

```shell
ENV=prod make package
ENV=prod make deploy
ENV=prod make outputs
ENV=prod make describe
```

# Usage

Jenkins Library Examples:

-   [Annotations](https://git.xarth.tv/dta/legacy-jenkins-libs/blob/master/vars/grafanaAnnotation.groovy)
-   [Dashboard](https://git.xarth.tv/dta/legacy-jenkins-libs/blob/master/vars/grafanaDashboard.groovy)

You may call this from any AWS Org account, just assume the role and pass a payload into the lambda. Examples follow.

-   Role: `arn:aws:iam::109561199089:role/grafana-annotations`
-   Lambda: `arn:aws:lambda:us-west-2:109561199089:function:GrafanaAnnotationsGateway`

### Annotations

```
{ "cmd": "annotate", "data": { "dashboardId": 1234, "text": "Something happened!" } }
```

Optional Data:

```
{
  "cmd": "annotate",
  "data": {
    "dashboardId": 4321,
    "panelId": 12,
    "text": "Annotation Text",
    "tags": [
      "tag1",
      "tag2"
    ]
  }
}

```

### Dashboards

The data inside the `{}` for `"dashboard"` should be a Grafana json dashboard.

```
{
  "cmd": "dashboard",
  "data": {
    "message": "Dashboard Update",
    "overwrite": "true",
    "dashboard": {}
  }
}
```

# Maintenance

The s3 buckets can be cleared out at will pretty much any time.
See `AWS_BUCKET_NAME` in the [Makefile](Makefile).

This stack is safe to redeploy,
but if you recreate the API key(s) Jenkins (and others?) will need to be updated.

There are two inputs from environment variables (you can see them in the lambda).
They are `GRAFANA_API_KEY_SM_NAME` and `GRAFANA_API_URL`. The former should be the
name of a secret in AWS Secrets Manager; this app will automatically acquire it
from there. All of this is setup in the CloudFormation template.
