# Cloudwatch Datasource

This repo contains a Go Lambda that processes Grafana CloudWatch Datasource requests.
The code was written to provide self-service account onboarding to grafana.xarth.tv.

## Description

Provided are two cloud formation stacks that make adding Grafana CloudWatch datasources easy
for all accounts in an AWS Org. The primary stack deploys a Go Lambda that handles CRUD
operations for a CloudWatch datasource in Grafana.
The datasource is create with another (consumer) CloudFormation stack that uses a
custom resource to notify an SNS topic. The SNS topic is org-writable and designed specifically
for a custom resource.

**Neither stack should be deployed into an account multiple times!**

# Consumers

[More info in the Wiki](https://wiki.xarth.tv/x/3oDaBw).

So you want to add your AWS account to [Grafana](https://grafana.xarth.tv) as a data
source? This is the right place! The recommended approach to adding a data source is
to deploy the CloudFormation [cloudwatch.yaml](cloudformation/cloudwatch.yaml) stack
into the  account and region where your metrics are located. You do not need to
download the file; you may simply provide this S3 URL to CloudFormation:
`http://s3.amazonaws.com/xarth-grafana-datasources-templates/cloudwatch.yaml`

The stack has a few input parameters. They come with defaults, and all of them are
optional. The default deploy will provide Grafana access to CloudWatch Metrics and
all CloudWatch Log Groups. You may restrict access to specific log groups by
replacing the `*` with a comma-delimited list of log group ARNs. You may remove
all Logs access by replacing the `*` with a dash `-`.

Similarly, you may provision additional data sources for AWS X-Ray and Amazon
Timestream by replacing their default `-` value with a `*` or a list of resource
ARNs that Grafana is permitted to access. These parameters control conditional
resources (data sources and IAM policies).

## Questions

[See the FAQ in the Wiki](https://wiki.xarth.tv/x/3oDaBw).

# Slack Integration

This stack comes with a "mandatory" Slack integration. This integration sends new
and deleted datasource requests to a slack channel.

# Deployment

This app is rarely deployed or updated. It was deployed manually using the
commands found below. If you need to update the app, follow this process:

1.  Make a PR.
1.  Deploy your changes to the development account.
1.  Test your changes on Dev Grafana.
1.  Get approval and make a Change Request.
1.  Deploy your changes to the production account.
1.  Merge your PR.

In order for this to work, you must already have created two Secrets Managers values:

-   `slack-webhook-url`
-   `grafana-admin-token`

These have already been provisioned in both accounts; should not have to be repeated.

## Development Account

These commands build the app, and deploy it to the development AWS account `twitch-grafana-dev`.
You must run `mwinit` first to add profile/credentials; or have `ada` setup.

This deploys the main stack:

```
GOOS=linux GOARCH=amd64 go build ./cmd/lambda && zip -m9 ./lambda.zip ./lambda && \
aws --profile=twitch-grafana-dev --region=us-west-2 cloudformation package \
    --template-file cloudformation/service.yaml \
    --output-template-file service-deploy.yaml \
    --s3-bucket twitch-grafana-dev && \
aws --profile=twitch-grafana-dev --region=us-west-2 cloudformation deploy \
    --template-file service-deploy.yaml \
    --stack-name dev-xarth-grafana-datasources \
    --capabilities CAPABILITY_IAM \
    --parameter-overrides `grep -Ev '^\s*(#|$$)' params-dev.json`
```

And this deploys the supplemental stack in us-east-2:

```
aws --profile=twitch-grafana-dev --region=us-east-2 cloudformation deploy \
    --template-file cloudformation/service-region.yaml \
    --stack-name dev-xarth-grafana-datasources \
    --capabilities CAPABILITY_IAM \
    --parameter-overrides MainStackName=dev-xarth-grafana-datasources
```

## Production Account

These commands build the app, and deploy it to the production AWS account `twitch-grafana-prod`.
You must run `mwinit` first to add profile/credentials; or have `ada` setup.

This deploys the main stack in us-west-2:

```
GOOS=linux GOARCH=amd64 go build ./cmd/lambda && zip -m9 ./lambda.zip ./lambda && \
aws --profile=twitch-grafana-prod --region=us-west-2 cloudformation package \
    --template-file cloudformation/service.yaml \
    --output-template-file service-deploy.yaml \
    --s3-bucket twitch-grafana-prod && \
aws --profile=twitch-grafana-prod --region=us-west-2 cloudformation deploy \
    --template-file service-deploy.yaml \
    --stack-name xarth-grafana-datasources \
    --capabilities CAPABILITY_IAM
```

And this deploys the supplemental stacks in other regions.
You should do this in every additional region that is supported.
ie. `us-east-1`, `us-east-2`, `ap-southeast-1`, `eu-west-1`, `eu-central-1`

```
for region in us-east-1 us-east-2 ap-southeast-1 eu-west-1 eu-central-1; do
  aws --profile=twitch-grafana-prod --region=${region} cloudformation deploy \
      --template-file cloudformation/service-region.yaml \
      --stack-name xarth-grafana-datasources \
      --capabilities CAPABILITY_IAM
done
```

### Consumer URL

Consumers use this URL to deploy the stack in their own Org-attached AWS account:

-   `http://s3.amazonaws.com/xarth-grafana-datasources-templates/cloudwatch.yaml`

After you deploy the stack, or if you update the [cloudwatch.yaml](cloudformation/cloudwatch.yaml)
file, it must be uploaded to s3. Example:

```
# prod:
aws --profile=twitch-grafana-prod --region=us-west-2 s3 cp cloudformation/cloudwatch.yaml s3://xarth-grafana-datasources-templates/
# dev:
aws --profile=twitch-grafana-dev --region=us-west-2 s3 cp cloudformation/cloudwatch.yaml s3://dev-xarth-grafana-datasources-templates/
```
