package main

import (
	"log"
	"os"

	"git.xarth.tv/Xarth-Grafana/cloudwatch-datasource/pkg/datasource"
	"git.xarth.tv/Xarth-Grafana/cloudwatch-datasource/pkg/slackhook"
	"github.com/aws/aws-lambda-go/cfn"
	"github.com/aws/aws-lambda-go/lambda"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/endpoints"
	"github.com/aws/aws-sdk-go/aws/session"
)

// Retries is how many times to retry AWS calls (secrets manager, sns).
const Retries = 3

func main() {
	var (
		sess = session.Must(session.NewSession())
		awsc = aws.NewConfig().WithMaxRetries(Retries).
			WithSTSRegionalEndpoint(endpoints.RegionalSTSEndpoint)
	)

	switch mode := os.Getenv("RUNMODE"); mode {
	case "datasource": // Datasource Manager / SNS Trigger.
		lambda.Start(cfn.LambdaWrapSNS(datasource.New(sess, awsc).LambdaHandler))
	case "notifier": // Slack Notifications / SNS Trigger.
		lambda.Start(slackhook.New(sess, awsc).LambdaHandler)
	default:
		log.Fatal("invalid RUNMODE:", mode)
	}
}
