package datasource

import (
	"context"
	"encoding/json"
	"log"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sns"
)

// SNS allows mocking SNS dispatches for tests.
type SNS interface {
	PublishWithContext(context.Context, *sns.PublishInput, ...request.Option) (*sns.PublishOutput, error)
}

// PublishSNS sends a mesage to an SNS topic.
func (c *Config) PublishSNS(ctx context.Context, msg interface{}) {
	b, err := json.Marshal(msg)
	if err != nil {
		log.Printf("[SNS ERROR] json marshal: %v", err)
		return //nolint:nlreturn
	}

	switch o, err := c.SNS.PublishWithContext(ctx, &sns.PublishInput{
		Message:  aws.String(string(b)),
		TopicArn: aws.String(c.SNSToken),
	}); {
	case err != nil:
		log.Printf("[SNS ERROR] %s: failed: %v", c.SNSToken, err)
	case o == nil || o.MessageId == nil || *o.MessageId == "":
		log.Printf("[SNS ERROR] no message ID returned!")
	default:
		log.Printf("[SNS SENT] %s: Message ID: %s, Bytes: %d", c.SNSToken, *o.MessageId, len(b))
	}
}
