package slackhook

import (
	"context"
	"encoding/json"
	"fmt"
	"log"

	"git.xarth.tv/Xarth-Grafana/cloudwatch-datasource/pkg/datasource"
	"github.com/aws/aws-lambda-go/events"
)

// LambdaHandler sends notifications to Slack from an SNS topic.
func (c *Config) LambdaHandler(ctx context.Context, snsEvent events.SNSEvent) error {
	if c.URL == "" || c.Channel == "" {
		return nil
	}

	if c.realURL == "" {
		if err := c.setURL(ctx); err != nil {
			return err
		}
	}

	for _, m := range snsEvent.Records {
		log.Printf("Incoming Message from %s: %s", m.EventSource, m.SNS.Message)

		if err := c.Notify(ctx, []byte(m.SNS.Message), &m.SNS); err != nil {
			return err
		}
	}

	return nil
}

// Notify tries to unmarshal the payload into a known data type.
func (c *Config) Notify(ctx context.Context, data []byte, m *events.SNSEntity) error {
	u := &datasource.Request{}
	if err := json.Unmarshal(data, u); err != nil {
		return fmt.Errorf("unknown payload: %w", err)
	}

	return c.NotifyDatasourceChanges(ctx, u)
}
