package main

import (
	"encoding/json"
	"fmt"
	"net/http"
	"strings"
)

// PrintMeta takes a list of dashboard UIDs and prints data about them.
func (f *Flags) PrintMeta(uids []string) error {
	if len(uids) <= 1 {
		return errNoDashboardUIDs
	}

	for _, uid := range uids {
		err := f.printMeta(uid)
		if err != nil {
			return err
		}
	}

	return nil
}

func (f *Flags) printMeta(uid string) error {
	//log.Printf("Pulling %s/api/dashboards/uid/%s\n", f.URL, uid)

	res, err := http.Get(f.URL + "/api/dashboards/uid/" + uid)
	if err != nil {
		return err
	}
	defer res.Body.Close()

	var dash struct {
		Dashboard `json:"meta"`
		DB        struct {
			Title string `json:"title"`
		} `json:"dashboard"`
	}

	err = json.NewDecoder(res.Body).Decode(&dash)
	if err != nil {
		return err
	}

	fmt.Println(f.Prefix + strings.Join([]string{
		dash.FolderTitle,
		dash.DB.Title,
		f.URL + dash.URL,
		dash.CreatedBy,
		dash.UpdatedBy,
	}, f.Delim) + f.Suffix)

	return nil
}
