# Graken

This is a Grafana CLI tool designed to be used by Administrators of
[https://grafana.xarth.tv](https://grafana.xarth.tv).
Use this tool to create data sources, teams and folders from the CLI.

1.  Start by getting an API key at
  [https://grafana.xarth.tv/org/apikeys](https://grafana.xarth.tv/org/apikeys).
1.  Then export the API key as env variable `GRAFANA_API_KEY`
```bash
export GRAFANA_API_KEY=kahjsdaksdjhaskdjhasdkjahsddssdfdtytsf==
```
1.  Get and use Graken:
```bash
go get -u git.xarth.tv/Xarth-Grafana/graken
go install git.xarth.tv/Xarth-Grafana/graken
graken -help
```
Run these commands once in a while to keep up to date.

## Usage

All of the options below can be used at the same time. You may create
a data source, a team and a folder all in one command. It is recommended
to create a folder at the same time as creating a team.

#### Data Sources

To add a data source you need to only provide the account name and ID. Like this:
```shell
graken --name "twitch-account-name" --id "123456789"
```
You should also provide an email address; this shows up as meta data on the data source.
```shell
graken --name "twitch-systems-prod" --id "12345678900" --email "systems-infra@twitch.tv"
```
If the data source has custom metrics, you can provide those too, comma separated.
```shell
graken --name "twitch-account-name" --id "12345678901" --metrics "CustomName1,CustomName2"
```

#### Teams

Teams require an LDAP Group. The group name should begin with `team-`.
The `team-` prefix is automatically applied, providing it is optional.
Add a new LDAP-sync'd team like this:
```shell
graken --team "New Team Name" --group "team-new-group"
```
This does the same thing:
```shell
graken --team "New Team Name" --group "new-group"
```

#### Folders

Each team needs at least one folder. You should add the folder at the same time
as the team. Like this:
```shell
graken --team "New Team Name" --group "team-new-group" --folder "New Team Infrastructure"
```

You can also add a folder for an existing team, but you need to provide the team
name exactly as it appears in Grafana.
```shell
graken --team "New Team Name" --folder "New Team Product Two"
```

#### Notification Channels (Alerts)

In order for Grafana to send alerts to engineers, it needs notification channels.
Each channel is configured with one or more recipients. Each channel can be tied
to an Alert on a Panel. Graken makes it easy to add more of these, whether they
be PagerDuty Integrations, Slack Channels or Email Addresses.

-   **Slack** needs a channel and an AWS profile for `twitch-grafana-prod`.
    The channel may then be configured as an alert destination in Grafana.
    The Slack API key (URL) belongs to AWS Infrastructure Platform; it's copied
    from SSM parameter store using the `twitch-grafana-prod` profile you provide.
```shell
AWS_PROFILE=twitch-grafana-prod graken --alertslack '#systems-infra-alerts'
```
-   **PagerDuty** needs an integration key and name.
    The channel may then be configured as an alert destination in Grafana.
    Please use the team's name that owns the account being notified;
    you may also append a service (pagerduty integration) name.
```shell
graken --alertname "Systems Infrastructure Hi-Pri" --alertpdkey fb4d06c6a7d24ed5388ed12be9fe576a
```
-   **Email channels** can have multiple recipients, separate them with a semicolon.
```shell
graken --alertemail "systems@twitch.tv;twitch-sysinfra@amazon.com"
```
