package main

import (
	"fmt"
	"log"

	"github.com/nexucis/grafana-go-client/api/types"
)

// DoNewFolder creates a new folder and adds an admin team to it.
func (g *Graken) DoNewFolder(teamID int64) (int64, error) {
	folders := g.client.Folders()

	folder, err := folders.Create(g.Folder, "")
	if err != nil {
		return 0, fmt.Errorf("creating folder: %w", err)
	}

	log.Println("Added new Folder:", g.Folder)

	editor := types.RoleEditor
	viewer := types.RoleViewer
	acl := []*types.DashboardACLUpdateItem{
		{Role: &editor, Permission: types.PermissionEdit},
		{Role: &viewer, Permission: types.PermissionView},
		{TeamID: teamID, Permission: types.PermissionAdmin},
	}

	if err := folders.UpdatePermissions(folder.UID, acl); err != nil {
		return folder.ID, fmt.Errorf("updating folder permissions: %w", err)
	}

	log.Printf("Added Team %d:%s as Admin to Folder: %s", teamID, g.Team, g.Folder)

	return folder.ID, nil
}
