# Xarth Grafana LDAP Sync

Grafana LDAP Group->Grafana Team Syncing Tool (Lambda).

## Description

This tool makes changes to Grafana Teams using the Grafana REST API. The changes
are: adding and deleting users to make a Team sync with an LDAP Group. That means
when properly tagged, a Team in Grafana will maintain the same usernames as a
corresponding group in LDAP.

## Tagging a Team

Teams have Names, Email address and Members. To make this tool sync the members
to an LDAP group you must set the email address to `team-group-name@ldap`. There
are only two rules. The group must begin with `team-`, but you may omit it from
the front-end configuration. This application will automatically prepend `team-`
to the group name if it's missing.  The second rule is that the data after the `@`
must contain the word `ldap`. Other than that, it's all ignored and stripped away.

Teams without the word `ldap` in the email domain will be ignored by this app,
and no changes will be made to them.

## LDAP HOWTO

Make a Group in LDAP with a name like `team-viewer-experience` or `team-ingest`. Add you users.

Then make a Team in Grafana with a name like `Viewer Experience` or `Ingest`. Set the email address
for the team to `viewer-experience@ldap.twitch` or `ingest@ldap.twitch` to match the
LDAP Group name.

That's it. Once the users login they'll be synchronized by this application.

## Application Logic

The application gathers all the users in Grafana because only users that have logged
in can be added to a team; despite being in the corresponding LDAP.
Then the app gathers all the Grafana Teams and the members in those Teams.
The LDAP group name for each team is parsed out of the Team email address.
Then a membership lookup for each group is performed against LDAP.

Once all this data is collected, we loop each team and intersect among:
-   who's a Grafana User
-   who's in the LDAP Group
-   who's in the Grafana Team

After deltas are calculated, a list of additional users and deletable users for
each Team is created then executed.

## Integration Testing

Just compile it and run it on your workstation while connected to Twitch VPN.
Set the ENV variable `GRAFANA_API_KEY` before running. The rest is automatic.
To test that is works, remove someone from a group they belong in and run it again.

## Build & Deploy

This repository uses a simple [Jenkinsfile](Jenkinsfile) and [build script](build.sh)
to compile this Go application, copy it to S3 and reload the lambda. The build and test
happens on every push to the repo. The production lambda is reloaded with this new code
on every push or merge to `main`. After deploy, go check the CloudWatch Logs in the
`twitch-grafana-prod` account. Then log out and back into [grafana.xarth.tv](https://grafana.xarth.tv).
The login action is currently what kicks this lambda off. That rule is configured by
the [terraform that created the lambda](https://git.xarth.tv/Xarth-Grafana/terraform/tree/main/production/ldap-sync).
