#!/bin/bash -x

set -e

# Build script to be run by Jenkins or something. See Jenkinsfile.
CMD=$1
HANDLER=grafana-ldap-sync
BUCKET=twitch-grafana-prod
S3_PATH=lambda
LAMBDA="${HANDLER}-production"


# Build the app, zip the binary, upload it to s3, test updating the lambda.
if [ "$CMD" == "build" ]; then
  # Make sure our code is in a compilable path.
  mkdir -p "${GOPATH}/src/gls"
  cp -r * "${GOPATH}/src/gls"
  cd "${GOPATH}/src/gls"
  go build -o "${HANDLER}" ./...

  zip -j9 "${HANDLER}-${BRANCH_NAME}.zip" "${HANDLER}"
  aws s3 cp "${HANDLER}-${BRANCH_NAME}.zip" "s3://${BUCKET}/${S3_PATH}/"

  # dry-run - test updating lambda.
  aws lambda --dry-run \
    update-function-code --function=$LAMBDA --s3-bucket=$BUCKET --s3-key "${S3_PATH}/${HANDLER}-${BRANCH_NAME}.zip"
fi


# Update Lambda with "main" branch zip file.
if [ "$CMD" == "deploy" ]; then
  aws s3 \
    cp "s3://${BUCKET}/${S3_PATH}/${HANDLER}-main.zip" "s3://${BUCKET}/${S3_PATH}/${HANDLER}.zip"
  aws lambda \
    update-function-code --function=$LAMBDA --s3-bucket=$BUCKET --s3-key "${S3_PATH}/${HANDLER}.zip"
fi
