-   [DOCS](https://wiki.twitch.com/x/KSCND)

This plan creates lambdas that restore a production database to dev every day.
It works in conjunction with the [aurora-snapshot-tool](https://github.com/awslabs/aurora-snapshot-tool/tree/499413e722773d0b5526bc2940d9214359a87bd9).

Two step functions and two lambdas are created. The step functions simply retry
(re-run) the lambdas if they fail/produce an error. The step functions run every
morning (two separate invocations) at 3 AM and 6:30 AM Pacific. One lambda deletes
old deployed production databases from the dev account. It deletes all but the
last one. The other lambda deploys the most recent production snapshot in the
dev account and waits for it to finish deploying - then it copies the database
contents using `pg_dump | psql` to the running dev database. The two cloud watch
events that fire the step functions are staggered in such a way that there will
always be two previous production databases running in the dev account.

-   Uses Terraform 0.12.12

Many of the dependencies in this module are created by the other pieces of the
grafana-dev terraform. They are loosely coupled. It is very possible to read
in the other state files or find their resources programmatically. For now, they
are hard coded as env variables and other data.
