# Throw a low priority alert when one of our state machines reports an error.

resource "aws_cloudwatch_metric_alarm" "grafana_lambdas_deploy_failed" {
  provider            = aws.twitch-grafana-dev
  alarm_name          = "Grafana Prod-to-Dev Database Deploy Lambda Failed"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "ExecutionsFailed"
  namespace           = "AWS/States"
  period              = "600"
  statistic           = "Sum"
  threshold           = "1"
  alarm_description   = "One of the grafana step function lambdas that deploys the prod db in dev failed."
  alarm_actions       = [aws_sns_topic.pagerduty.arn]
  dimensions = {
    StateMachineArn = aws_sfn_state_machine.aurora_lambdas_deploy.id
  }
}

resource "aws_cloudwatch_metric_alarm" "grafana_lambdas_deploy_timedout" {
  provider            = aws.twitch-grafana-dev
  alarm_name          = "Grafana Prod-to-Dev Database Deploy Lambda Timed Out"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "ExecutionsTimedOut"
  namespace           = "AWS/States"
  period              = "600"
  statistic           = "Sum"
  threshold           = "1"
  alarm_description   = "One of the grafana step function lambdas that deploys the prod db in dev reported a timeout."
  alarm_actions       = [aws_sns_topic.pagerduty.arn]
  dimensions = {
    StateMachineArn = aws_sfn_state_machine.aurora_lambdas_deploy.id
  }
}

resource "aws_cloudwatch_metric_alarm" "grafana_lambdas_delete_failed" {
  provider            = aws.twitch-grafana-dev
  alarm_name          = "Grafana Prod-to-Dev Database Delete Lambda Failed"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "ExecutionsFailed"
  namespace           = "AWS/States"
  period              = "600"
  statistic           = "Sum"
  threshold           = "1"
  alarm_description   = "One of the grafana step function lambdas that deletes the prod db in dev failed."
  alarm_actions       = [aws_sns_topic.pagerduty.arn]
  dimensions = {
    StateMachineArn = aws_sfn_state_machine.aurora_lambdas_delete.id
  }
}

resource "aws_cloudwatch_metric_alarm" "grafana_lambdas_delete_timedout" {
  provider            = aws.twitch-grafana-dev
  alarm_name          = "Grafana Prod-to-Dev Database Delete Lambda Timed Out"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "ExecutionsTimedOut"
  namespace           = "AWS/States"
  period              = "600"
  statistic           = "Sum"
  threshold           = "1"
  alarm_description   = "One of the grafana step function lambdas that deletes the prod db in dev reported a timeout."
  alarm_actions       = [aws_sns_topic.pagerduty.arn]
  dimensions = {
    StateMachineArn = aws_sfn_state_machine.aurora_lambdas_delete.id
  }
}

