#!/usr/bin/env bash
set -e

# This helper script creates an archive from terraform.
# We need this to preserve the executable bits on our binaries.

DIR=$1
if [[ "$DIR" == "" ]]; then
  echo "provide directory"
  exit 1
fi

# make sure you have the `-q` flag to not mess with the output JSON
zip -uqj ${DIR}.zip ${DIR}/* || true
HASH=$(cat "${DIR}.zip" | openssl sha -binary -sha256 | base64)
echo "{ \"hash\": \"${HASH}\", \"path\": \"${DIR}.zip\"}"
