provider "aws" {
  alias   = "twitch-grafana-dev"
  profile = "twitch-grafana-dev"
  region  = "us-west-2"
}

# This is where remote state is stored. Do not recommend changing this.
terraform {
  backend "s3" {
    bucket  = "twitch-grafana-dev"
    key     = "tfstate/development/grafana-dev/dbrestore/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-grafana-dev"
  }
}

data "aws_iam_policy_document" "aurora_lambdas_policy" {
  provider = aws.twitch-grafana-dev
  statement {
    sid    = ""
    effect = "Allow"
    principals {
      identifiers = ["states.amazonaws.com", "lambda.amazonaws.com", "events.amazonaws.com"]
      type        = "Service"
    }
    actions = ["sts:AssumeRole"]
  }
}

data "aws_iam_policy_document" "aurora_lambdas_actions" {
  provider = aws.twitch-grafana-dev
  statement {
    actions   = ["rds:*"]
    resources = ["*"]
  }
  statement {
    actions   = ["states:StartExecution"]
    resources = ["*"]
  }
  statement {
    actions   = ["lambda:InvokeFunction"]
    resources = ["*"]
  }
  statement {
    actions   = ["kms:*"]
    resources = ["arn:aws:kms:us-west-2:109561199089:key/65ce811c-ddc3-4443-a3af-80f002cf4e1c"] # prod key.
  }
}

resource "aws_iam_role" "aurora_lambdas" {
  provider           = aws.twitch-grafana-dev
  name               = "aurora-deploy-delete-lambdas"
  assume_role_policy = data.aws_iam_policy_document.aurora_lambdas_policy.json
}

resource "aws_iam_policy" "aurora_lambdas_actions" {
  provider = aws.twitch-grafana-dev
  name     = "aurora-deploy-delete-lambdas"
  policy   = data.aws_iam_policy_document.aurora_lambdas_actions.json
}

resource "aws_iam_role_policy_attachment" "aurora_lambdas_actions" {
  provider   = aws.twitch-grafana-dev
  role       = aws_iam_role.aurora_lambdas.name
  policy_arn = aws_iam_policy.aurora_lambdas_actions.arn
}

resource "aws_iam_role_policy_attachment" "vpc_permission" {
  provider   = aws.twitch-grafana-dev
  role       = aws_iam_role.aurora_lambdas.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole"
}

