# If CPU is below this for a minute it will scale down containers
variable "as_cpu_low" {
  default = "20"
}

# If CPU is above this for a minute it will scale down containers
variable "as_cpu_high" {
  default = "80"
}

resource "aws_cloudwatch_metric_alarm" "cpu_high" {
  alarm_name          = "grafana-server-${var.environment}-CPU-Utilization-High-${var.as_cpu_high}"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/ECS"
  period              = "60"
  statistic           = "Average"
  threshold           = var.as_cpu_high

  dimensions = {
    ClusterName = aws_ecs_cluster.grafana_server.name
    ServiceName = aws_ecs_service.grafana_server.name
  }

  alarm_actions = [aws_appautoscaling_policy.grafana_server_up.arn]
}

resource "aws_cloudwatch_metric_alarm" "cpu_utilization_low" {
  alarm_name          = "grafana_server-${var.environment}-CPU-Utilization-Low-${var.as_cpu_low}"
  comparison_operator = "LessThanThreshold"
  evaluation_periods  = "1"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/ECS"
  period              = "60"
  statistic           = "Average"
  threshold           = var.as_cpu_low

  dimensions = {
    ClusterName = aws_ecs_cluster.grafana_server.name
    ServiceName = aws_ecs_service.grafana_server.name
  }

  alarm_actions = [aws_appautoscaling_policy.grafana_server_down.arn]
}

resource "aws_appautoscaling_policy" "grafana_server_up" {
  name               = "grafana-server-scale-up"
  service_namespace  = aws_appautoscaling_target.grafana_server.service_namespace
  resource_id        = aws_appautoscaling_target.grafana_server.resource_id
  scalable_dimension = aws_appautoscaling_target.grafana_server.scalable_dimension

  step_scaling_policy_configuration {
    adjustment_type         = "ChangeInCapacity"
    cooldown                = 60
    metric_aggregation_type = "Average"

    step_adjustment {
      metric_interval_lower_bound = 0
      scaling_adjustment          = 1
    }
  }
}

resource "aws_appautoscaling_policy" "grafana_server_down" {
  name               = "app-scale-down"
  service_namespace  = aws_appautoscaling_target.grafana_server.service_namespace
  resource_id        = aws_appautoscaling_target.grafana_server.resource_id
  scalable_dimension = aws_appautoscaling_target.grafana_server.scalable_dimension

  step_scaling_policy_configuration {
    adjustment_type         = "ChangeInCapacity"
    cooldown                = 300
    metric_aggregation_type = "Average"

    step_adjustment {
      metric_interval_upper_bound = 0
      scaling_adjustment          = -1
    }
  }
}

